/**
 * Refinement plugin
 */

/******************************************
 *                                        *
 *    RenderWare(TM) Graphics Library     *
 *                                        *
 ******************************************/

/*
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 1998. Criterion Software Ltd.
 * All Rights Reserved.
 */

/***************************************************************************
 *                                                                         *
 * Module  : rprefine.h                                                       *
 *                                                                         *
 * Purpose : Atomic refinement                                                  *
 *                                                                         *
 **************************************************************************/

#ifndef RPREFINE_H
#define RPREFINE_H

/**
 * \defgroup rprefine RpRefine
 * \ingroup retired
 *
 * Geometric Refinement Plug-In for RenderWare.
 */

/****************************************************************************
 Includes
 */

#include <rwcore.h>
#include <rpworld.h>

#include <rpcriter.h>          /* Note: each vendor can choose their own method for
                                * allocation of unique ID's. This file defines
                                * the ID's used by Criterion.
                                */
#include "rprefine.rpe"        /* automatically generated header file */

/****************************************************************************
 Defines
 */
#define RPREFINEMINDEPTH 1
#define RPREFINEMAXDEPTH 10


/****************************************************************************
 Type defs
 */

typedef struct RpNodeRefineData RpNodeRefineData;
struct RpNodeRefineData
{
/* The refinement node generates new vertices and so has to interpolate
   per-vertex attributes from the original set of vertices to generate values
   for the generated vertices. It can (barycentrically) interpolate any
   number of additional 'passes' of UVs or RGBAs, provided that:
     (a) these extra clusters are added by the app at pipeline construction
         time through the use of RxPipelineNodeRequestCluster(),
     (b) the extra UVs/RGBAs are the last clusters added to the node, and
     (c) all the UVs come before the RGBAs (and there are no other cluster
         types sprinkled in amongst the UVs/RGBAs) */
    RwBool  refineOn;
    RwInt32 numExtraUVs;
    RwInt32 numExtraRGBAs;
};

typedef RwInt32 (*RpRefineAtomicDepthCallBack)( RpAtomic *atomic );

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

    extern RwBool
        RpRefinePluginAttach( void );

    extern RpAtomic *
        RpRefineAtomicSetDepth(
            RpAtomic *atomic, RwInt32 depth );

    extern RwInt32
        RpRefineAtomicGetDepth(
            RpAtomic *atomic );

    extern RpAtomic *
        RpRefineAtomicSetRange(
            RpAtomic *atomic, RwReal farRange );

    extern RwReal
        RpRefineAtomicGetRange(
            RpAtomic *atomic );

    extern RpAtomic *
        RpRefineAtomicSetDepthCallBack(
            RpAtomic *atomic,
            RpRefineAtomicDepthCallBack callback );

#ifdef RXPIPELINE

    extern RxNodeDefinition *
        RxNodeDefinitionGetRefineCSL( void );

/****************************************************************************
 * SSE Specific
 */

    extern RxNodeDefinition *
        RxNodeDefinitionGetSSERefineCSL( void );

#endif /* RXPIPELINE */

/****************************************************************************
 * Internal
 */

    extern RwInt32 *
        _rpRefineGetVertIndexArray( RwInt32 depth );


#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* RPREFINE_H */

