/*
 * Particle System plugin
 */

#ifndef RPPRTSYS_H
#define RPPRTSYS_H

/**
 * \defgroup rpprtsys RpPrtSys
 * \ingroup rpplugin
 *
 * Particle System Plugin for RenderWare.
 */

#include <rwcore.h>
#include <rpworld.h>

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */


extern  RwBool 
RpParticlesAtomicPluginAttach(void);

extern  RpAtomic * 
RpParticlesAtomicDestroyAuxiliaryData(RpAtomic * atomic,
                                      void * data);

extern  RpAtomic * 
RpParticlesAtomicCreate(RwInt32 numParticles,
                        RpMaterial * material);

extern  RwBool 
RpParticlesAtomicIsAParticlesAtomic(RpAtomic * atomic);

extern  RwInt32 
RpParticlesAtomicGetNumParticles(RpAtomic * atomic);

extern  RpAtomic * 
RpParticlesAtomicSetEmitterSize(RpAtomic * atomic,
                                RwReal width,
                                RwReal length);

extern  RwV2d 
RpParticlesAtomicGetEmitterSize(RpAtomic * atomic);

extern  RpAtomic * 
RpParticlesAtomicSetEmitterAngle(RpAtomic * atomic,
                                 RwReal angle);

extern  RwReal 
RpParticlesAtomicGetEmitterAngle(RpAtomic * atomic);

extern  RpAtomic * 
RpParticlesAtomicSetSize(RpAtomic * atomic,
                         RwReal size,
                         RwReal growth,
                         RwReal aspectRatio);

extern  void 
RpParticlesAtomicGetSize(RpAtomic * atomic,
                         RwReal * size,
                         RwReal * growth,
                         RwReal * aspectRatio);

extern  RpAtomic * 
RpParticlesAtomicSetSpeed(RpAtomic * atomic,
                          RwReal speedMin,
                          RwReal speedMax,
                          RwReal dampening);

extern  void 
RpParticlesAtomicGetSpeed(RpAtomic * atomic,
                          RwReal * speedMin,
                          RwReal * speedMax,
                          RwReal * dampening);

extern  RpAtomic * 
RpParticlesAtomicSetFlightTime(RpAtomic * atomic,
                               RwReal flightTime);

extern  RwReal 
RpParticlesAtomicGetFlightTime(RpAtomic * atomic);

extern  RpAtomic * 
RpParticlesAtomicSetForce(RpAtomic * atomic,
                          RwV3d * force);

extern  RwV3d 
RpParticlesAtomicGetForce(RpAtomic * atomic);

extern  RpAtomic * 
RpParticlesAtomicSetColors(RpAtomic * atomic,
                           RwRGBA * colStart,
                           RwRGBA * colEnd);

extern  RwRGBA 
RpParticlesAtomicGetColors(RpAtomic * atomic,
                           RwInt32 index);

extern  RpAtomic * 
RpParticlesAtomicUpdate(RpAtomic * atomic,
                        RwReal timeDelta);

extern  RpAtomic * 
RpParticlesAtomicSetMaterial(RpAtomic * atomic,
                             RpMaterial * material);

extern  RpMaterial *
RpParticlesAtomicGetMaterial(RpAtomic * atomic);

extern RwBool 
_rpParticlesSetupPipes(void);

extern RpAtomic * 
_rpParticleAddGeomData(RpAtomic * atomic,
                       RwInt32 numPrtsys);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* RPPRTSYS_H */

