/** 
 * Bones plugin
 */

#ifndef RPBONES_H
#define RPBONES_H

/**
 * \defgroup rpbone RpBone
 * \ingroup retired
 *
 * Bone Plug-In for RenderWare.
 */

/****************************************************************************
 Includes
 */

/* RenderWare */
#include "rwcore.h"
#include "rpworld.h"

#include "rpbone.rpe"    /* automatically generated header file */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif /* RPBONES_H */

/* Vertex bone linking functions */
extern RpClump *
_rpBodyLinkBonesByProximity(RpClump *clump);

extern RpClump *
_rpBodyLinkBonesByHull(RpClump *clump);

extern RpClump *
_rpBodyLinkBonesByMap(RpClump *clump, RwInt32 *vertexTagMap);

/* API */
extern RpClump *
RpBoneClumpInitialize(RpClump *clump);

extern RwBool
RpBoneGenerateBodyParts(RpClump *clump);

extern RwBool
RpBoneClumpSkinUpdate(RpClump *clump);

extern RwBool 
RpBonePluginAttach(void);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif  /* RPBONES_H */

