
#ifndef VERT_DEFS_H
#define VERT_DEFS_H


/* For use in the vertex shader descriptor */
#define VSD_REG_POS                     0
#define VSD_REG_VEL                     1
#define VSD_REG_STARTTIME               2
#define VSD_REG_TEXCOORDS               3


/* Input register - For use in the vertex shader code */
#define VSIN_REG_POS                    v0
#define VSIN_REG_VEL                    v1
#define VSIN_REG_STARTIME               v2.x
#define VSIN_REG_TEXCOORDS              v3

/* Temporary register - For use in the vertex shader code */
#define VSTMP_REG_TIME                  r0
#define VSTMP_REG_TIME_TMP              VSTMP_REG_TIME.x
#define VSTMP_REG_TIMEGT_TMP            r0.y
#define VSTMP_REG_TIMESQ                r0
#define VSTMP_REG_TIMESQ_TMP            VSTMP_REG_TIMESQ.z
#define VSTMP_REG_TIMENORM_TMP          r0.w
//#define VSTMP_REG_ONE_MINUS_TIMENORM    r5
#define VSTMP_REG_POS_ACCUM             r1
#define VSTMP_REG_GROWTH                r2
#define VSTMP_REG_GROWTH_TMP            VSTMP_REG_GROWTH.x
#define VSTMP_REG_SIZE_TMP              r3
#define VSTMP_REG_UV_TMP                r4
#define VSTMP_REG_COL_TMP               r6

/* Constant register */
#define VSCONST_REG_TIMEANDGROWTH       1
#define VSCONST_REG_FORCE               2
#define VSCONST_REG_STARTCOLOR          3
//#define VSCONST_REG_ENDCOLOR            4
#define VSCONST_REG_DELCOLOR            4
#define VSCONST_REG_PARTICLESIZE        5
#define VSCONST_REG_ONEANDHALFANDTWO    6
#define VSCONST_REG_UP                  7
#define VSCONST_REG_RIGHT               8
#define VSCONST_REG_TRANSFORM_OFFSET    9
#define VSCONST_REG_TRANSFORM_SIZE      4
#define VSCONST_REG_TRANSFORM_X         c[VSCONST_REG_TRANSFORM_OFFSET]
#define VSCONST_REG_TRANSFORM_Y         c[VSCONST_REG_TRANSFORM_OFFSET+1]
#define VSCONST_REG_TRANSFORM_Z         c[VSCONST_REG_TRANSFORM_OFFSET+2]
#define VSCONST_REG_TRANSFORM_W         c[VSCONST_REG_TRANSFORM_OFFSET+3]

#define VSCONST_REG_TIME                c[VSCONST_REG_TIMEANDGROWTH].x
#define VSCONST_REG_FLIGHTTIME          c[VSCONST_REG_TIMEANDGROWTH].y
#define VSCONST_REG_OOFLIGHTTIME        c[VSCONST_REG_TIMEANDGROWTH].z
#define VSCONST_REG_GROWTH              c[VSCONST_REG_TIMEANDGROWTH].w

#define VSCONST_REG_ONE                 c[VSCONST_REG_ONEANDHALFANDTWO].x
#define VSCONST_REG_HALF                c[VSCONST_REG_ONEANDHALFANDTWO].y
#define VSCONST_REG_TWO                 c[VSCONST_REG_ONEANDHALFANDTWO].z

#endif /* VERT_DEFS_H */
