/****************************************************************************
 *                                                                          *
 *  Module  :   p2define.h                                                  *
 *                                                                          *
 *  Purpose :   See p2define.c                                              *
 *                                                                          *
 ****************************************************************************/

#ifndef DEFINEPIPE_H
#define DEFINEPIPE_H

/****************************************************************************
 Includes
 */

#include "p2core.h"

/****************************************************************************
 Global Types
 */

/* RWPUBLIC */

/**
 * \ingroup rwcoregeneric
 * \typedef RxNodeOutput 
 * typedef for a reference to an output of a pipeline node */
typedef RwUInt32       *RxNodeOutput;

/**
 * \ingroup rwcoregeneric
 * \typedef RxNodeInput 
 *  typedef for a reference to the input of a pipeline node */
typedef RxPipelineNode *RxNodeInput;

/**
 * \ingroup rwcoregeneric
 * \typedef RxLockedPipe
 * typedef for a reference to a locked pipeline 
 */
typedef RxPipeline      RxLockedPipe;

/* RWPUBLICEND */

/****************************************************************************
 Global Prototypes
 */

/* RWPUBLIC */

#ifdef    __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* PIPELINENODE API */

extern RxNodeOutput RxPipelineNodeFindOutputByName(RxPipelineNode *node, 
                                                   const char *outputname);
extern RxNodeOutput RxPipelineNodeFindOutputByIndex(RxPipelineNode *node,
                                                    RwUInt32 outputindex);
extern RxNodeInput  RxPipelineNodeFindInput(RxPipelineNode *node);

extern RxNodeDefinition *
RxPipelineNodeCloneDefinition(RxPipelineNode *node,
                              RxClusterDefinition *cluster2add);

extern RxPipeline *
RxPipelineNodeRequestCluster(RxPipeline *pipeline,
                             RxPipelineNode *node,
                             RxClusterDefinition *clusterDef);
extern RxPipeline *
RxPipelineNodeReplaceCluster(RxPipeline *pipeline,
                             RxPipelineNode *node,
                             RxClusterDefinition *oldClusterDef,
                             RxClusterDefinition *newClusterDef);

extern void *RxPipelineNodeGetInitData(RxPipelineNode *node);
extern void *RxPipelineNodeCreateInitData(RxPipelineNode *node,
                                          RwUInt32 size);

/* PIPELINE MANIPULATION API */

extern RxPipeline     *RxPipelineClone(RxPipeline *pipeline);

extern RxPipelineNode *RxPipelineFindNodeByName(RxPipeline *pipeline, 
                                                const RwChar *name,
                                                RxPipelineNode *start,
                                                RwInt32 *index);
extern RxPipelineNode *RxPipelineFindNodeByIndex(RxPipeline *pipeline,
                                                 RwUInt32 nodeindex);

extern RxLockedPipe   *RxPipelineLock(RxPipeline *pipeline);
extern RxPipeline     *RxLockedPipeUnlock(RxLockedPipe *pipeline);

extern RxLockedPipe   *RxLockedPipeAddFragment(RxLockedPipe *pipeline,
                                               RwUInt32 *firstIndex,
                                               RxNodeDefinition *nodeDef0,
                                               ...);

extern RxPipeline     *RxLockedPipeReplaceNode(RxLockedPipe *pipeline,
                                               RxPipelineNode *node,
                                               RxNodeDefinition *nodeDef);
extern RxPipeline     *RxLockedPipeDeleteNode(RxLockedPipe *pipeline,
                                              RxPipelineNode *node);

extern RxPipeline     *RxLockedPipeSetEntryPoint(RxLockedPipe *pipeline,
                                                 RxNodeInput in);

extern RxPipelineNode *RxLockedPipeGetEntryPoint(RxLockedPipe *pipeline);

extern RxPipeline     *RxLockedPipeAddPath(RxLockedPipe *pipeline,
                                           RxNodeOutput out,
                                           RxNodeInput in);
extern RxPipeline     *RxLockedPipeDeletePath(RxLockedPipe *pipeline,
                                              RxNodeOutput out,
                                              RxNodeInput in);

extern RxPipeline     *RxPipelineInsertDebugNode(RxPipeline *pipeline,
                                                 RxPipelineNode *before,
                                                 RxPipelineNode *after,
                                                 RxNodeDefinition *debugNode);

#ifdef    __cplusplus
}
#endif /* __cplusplus */

/* RWPUBLICEND */

#endif /* DEFINEPIPE_H */
