
/**************************************************************************
 *                                                                        *
 * Module  : pen.h                                                        *
 *                                                                        *
 * Purpose :                                                              *
 *                                                                        *
 **************************************************************************/

#ifndef FONT_H
#define FONT_H

/****************************************************************************
 Includes
 */
#include "path.h"

/****************************************************************************
 Defines
 */
#define rtFONTMAXPAGES   4
#define rtFONTCHARCOUNT (1<<(sizeof(RwChar)<<3))

#define rtFONTFLAG_SINGLEPAGE    0x01

/****************************************************************************
 Global Types
 */

/*
 * Font rendering callback
 */
typedef Rt2dFont   *(*Rt2dFontShowCallBack)
    (Rt2dFont * font, const RwChar * string,
     RwReal height, RwV2d * anchor, Rt2dBrush * brush);

typedef struct rt2dCharRect rt2dCharRect;
struct rt2dCharRect
{
    RwReal              width;
    RwRaster           *bm;
    RwV2d               uv[2];
    Rt2dPath           *path;
};

struct Rt2dFont
{
    RwBool              isOutline;
    RwReal              height, baseline;
    RwReal              intergap;

    RwUInt32            flag;

    RwTexDictionary    *texdict;

    rt2dCharRect        map[rtFONTCHARCOUNT];
    RwChar              charpage[rtFONTCHARCOUNT];

    Rt2dFontShowCallBack fontshowCB;

    Rt2dFont           *nextBatch;
    void               *strCache;
};

/* Force to unsigned char, assuming wchar_t is also unsigned */

#ifdef RWUNICODE
typedef wchar_t     Rt2dFontChar;
#else /* RWUNICODE */
typedef unsigned char Rt2dFontChar;
#endif /* RWUNICODE */

/****************************************************************************
Function prototypes
*/

extern Rt2dFont    *_rt2dFontGetStringInfo(Rt2dFont * font,
                                           const RwChar * string,
                                           RwReal * width, RwInt32 * l);

extern RwBool       _rt2dFontOpen(void);

extern void         _rt2dFontClose(void);

#endif /* FONT_H */
