/* 
 * Functionality for 2D rendering
 *
 * Copyright (c) 1998 Criterion Software Ltd.
 */

/****************************************************************************
 *                                                                          *
 *  Module  :   pipes.c                                                     *
 *                                                                          *
 *  Purpose :   pipeline                                                    *
 *                                                                          *
 ****************************************************************************/

/**
 * \defgroup rt2dps2 PS2
 * \ingroup rt2d
 *
 * 2D Rendering Toolkit for RenderWare.
 *
 * PS2 Specific.
 */

/**
 * \ingroup rt2dps2
 * \page rt2dps2overview Rt2d PS2 Overview
 *
 * Clipping is not performed on the PS2. It is assumed that Rt2d is
 * used for rendering 2d objects that are in or partially in view. Since the
 * 2d objects will never be clipped by the near clip plane, clipping has been
 * removed for improving performance.
 */


/****************************************************************************
 Includes
 */

#include <rwcore.h>
#include <rpworld.h>
#include <rpdbgerr.h>

#include "rt2d.h"

#include "font.h"
#include "ps2pipes.h"
#include "gstate.h"

#include "ps2font.h"
#include "ps2fill.h"
#include "ps2stroke.h"
#include "ps2sgfnt.h"

/***************************************************************************
 Local Defines
 */

/****************************************************************************
						 Local (static) Globals
 ***************************************************************************/

/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   Functions

   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

RwBool
_rt2dPS2PipeOpen(void)
{
    RwBool              result;

    RWFUNCTION(RWSTRING("_rt2dPS2PipeOpen"));

    result = TRUE;

    /* establish pipeline */
    Rt2dGlobals.default_pipe = NULL;
    Rt2dGlobals.use_pipe = NULL;

    Rt2dGlobals.default_stroke_pipe = NULL;
    Rt2dGlobals.use_stroke_pipe = NULL;

    Rt2dGlobals.default_fill_pipe = NULL;
    Rt2dGlobals.use_fill_pipe = NULL;

    rt2dPS2StrokePipe();
    rt2dPS2FillPipe();
    _rt2dPS2FontPipe();
    _rt2dPS2SingleFontPipe();

    RWRETURN(result);
}

/*****************************************************************************/
void
_rt2dPS2PipeClose(void)
{
    RWFUNCTION(RWSTRING("_rt2dPS2PipeClose"));

    if (Rt2dGlobals.default_pipe != NULL)
        RxPipelineDestroy(Rt2dGlobals.default_pipe);

    if (Rt2dGlobals.default_stroke_pipe != NULL)
        RxPipelineDestroy(Rt2dGlobals.default_stroke_pipe);

    if (Rt2dGlobals.default_fill_pipe != NULL)
        RxPipelineDestroy(Rt2dGlobals.default_fill_pipe);

    if (Rt2dGlobals.default_font_pipe != NULL)
        RxPipelineDestroy(Rt2dGlobals.default_font_pipe);

    if (Rt2dGlobals.default_sgfont_pipe != NULL)
        RxPipelineDestroy(Rt2dGlobals.default_sgfont_pipe);

    Rt2dGlobals.default_pipe = NULL;
    Rt2dGlobals.use_pipe = NULL;

    RWRETURNVOID();
}
