
/***************************************************************************
 *                                                                         *
 * Module  : pssgfont.h                                                      *
 *                                                                         *
 * Purpose :                                                               *
 *                                                                         *
 **************************************************************************/

#ifndef PS2SINGLEFONT_H
#define PS2SINGLEFONT_H

/****************************************************************************
 Includes
 */
#include "path.h"
#include "brush.h"
#include "font.h"

/****************************************************************************
 Defines
 */

#define RT2DPS2STRCACHEMAXCHAR 16

#define RT2DPS2STRCACHEFLAGCONST      0x01

/****************************************************************************
 Global Types
 */

struct Rt2dPS2StrCache
{
    /* First element to ensure correct alignment of the ctm. */
    RwMatrix            ctm;

    RwInt32             flag;
    struct Rt2dPS2StrCache *nextCache;

    Rt2dFont           *font;

    rt2dShadeParameters top, dtop, bottom, dbottom;

    RwReal              halfwidth;
    RwInt32             numChar;
    RwInt32             length;
    RwReal              baseu;
    RwReal              oobaseu;
    RwReal              inset;
    RwReal              layerDepth;

    Rt2dFontChar       *str;
    Rt2dFontChar       *strBuffer;
};

 /****************************************************************************
 Function prototypes
 */
extern RxPipeline  *_rt2dPS2SingleFontPipe(void);

extern Rt2dFont    *_rt2dPS2SingleFontShow(Rt2dFont * font,
                                           const RwChar * string,
                                           RwReal height,
                                           RwV2d * anchor,
                                           Rt2dBrush * brush);

extern RwBool       _rt2dPS2SingleFontFlush(void);

extern RwBool       _rt2dPS2SingleFontOpen(void);

extern RwBool       _rt2dPS2SingleFontClose(void);

#endif /* PS2SGFONT_H */
