#ifndef BAPIPEW_H
#define BAPIPEW_H

#include <rwcore.h>

#include "baworld.h"
#include "basector.h"
#include "baclump.h"
#include "bamateri.h"

/* API */

extern RwBool _rpWorldPipeAttach(void);
extern RwBool rpWorldPipelineOpen( void);
extern void   rpWorldPipelineClose(void);

#ifdef    __cplusplus
extern "C"
{
#endif /* __cplusplus */
extern RwBool _rxWorldDevicePluginAttach(void);
#ifdef    __cplusplus
}
#endif /* __cplusplus */



/* RWPUBLIC */

#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */

#ifdef    __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RxPipeline    *RpWorldGetGenericSectorInstancePipeline(void);
extern RxPipeline    *RpWorldSetDefaultSectorInstancePipeline(RxPipeline *pipeline);
extern RxPipeline    *RpWorldGetDefaultSectorInstancePipeline(void);
extern RpWorld       *RpWorldSetSectorInstancePipeline(RpWorld *world,        RxPipeline  *pipeline);
extern RpWorld       *RpWorldGetSectorInstancePipeline(RpWorld *world,        RxPipeline **pipeline);
extern RpWorldSector *RpWorldSectorSetInstancePipeline(RpWorldSector *sector, RxPipeline  *pipeline);
extern RpWorldSector *RpWorldSectorGetInstancePipeline(RpWorldSector *sector, RxPipeline **pipeline);

extern RxPipeline    *RpAtomicGetGenericInstancePipeline(void);
extern RxPipeline    *RpAtomicGetDefaultInstancePipeline(void);
extern RxPipeline    *RpAtomicSetDefaultInstancePipeline(RxPipeline *pipeline);
extern RpAtomic      *RpAtomicSetInstancePipeline(RpAtomic *atomic, RxPipeline  *pipeline);
extern const RpAtomic      *RpAtomicGetInstancePipeline(const RpAtomic * const atomic, 
                                                  RxPipeline **pipeline);

extern RxPipeline    *RpMaterialGetGenericRenderPipeline(void);
extern RxPipeline    *RpMaterialSetDefaultRenderPipeline(RxPipeline *pipeline);
extern RxPipeline    *RpMaterialGetDefaultRenderPipeline(void);
extern RpMaterial    *RpMaterialSetRenderPipeline(RpMaterial *material, RxPipeline  *pipeline);
extern RpMaterial    *RpMaterialGetRenderPipeline(RpMaterial *material, RxPipeline **pipeline);

extern const RpGeometry *RpGeometryIsCorrectlySorted(const RpGeometry * geometry,
                                                     RwBool * result);
extern RpGeometry  *RpGeometrySortByMaterial(const RpGeometry * geometry,
                                             RpGeometrySortByMaterialCallBack  callback);

#ifdef    __cplusplus
}
#endif /* __cplusplus */

/* RWPUBLICEND */

#endif /* BAPIPEW_H */
