
/****************************************************************************
 *                                                                          *
 * module : native.c                                                        *
 *                                                                          *
 * purpose: Write/Read native data                                          *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 includes
 */

#include "rwcore.h"
#include "baworld.h"
#include "native.h"

/****************************************************************************
 Local defines
 */

/****************************************************************************
 Local types
 */

/****************************************************************************
 Externed globals
 */

RwStream           *
_rpGeometryNativeWrite(RwStream * stream, const RpGeometry * geometry)
{
    RWFUNCTION(RWSTRING("_rpGeometryNativeWrite"));
    RWASSERT(stream);
    RWASSERT(geometry);

    if (geometry->instanceFlags & rpGEOMETRYPERSISTENT)
    {
        /* Write some native data */
    }

    RWRETURN(stream);
}

RpGeometry         *
_rpGeometryNativeRead(RwStream * __RWUNUSED__ stream, 
                      RpGeometry * geometry)
{
    RWFUNCTION(RWSTRING("_rpGeometryNativeRead"));
    RWASSERT(stream);
    RWASSERT(geometry);

    geometry->instanceFlags = rpGEOMETRYPERSISTENT;

    RWRETURN(geometry);
}

RwInt32
_rpGeometryNativeSize(const RpGeometry * geometry)
{
    RwUInt32            size = 0;

    RWFUNCTION(RWSTRING("_rpGeometryNativeSize"));
    RWASSERT(geometry);

    if (geometry->instanceFlags & rpGEOMETRYPERSISTENT)
    {
        /* Calculat the native data size */
    }

    RWRETURN(size);
}
