/* The documentation in here is platform-specific versions of function-
   -descriptions for functions in bapipew.c */
/* 
 * Manipulating world object custom pipelines (platform-specific) 
 * 
 * Copyright (c) Criterion Software Limited
 */
/* #include <assert.h> */
#include <float.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rwcore.h"

#include "balight.h"
#include "baworld.h"

#include "bapipew.h"

#include "wrldpipe.h"

static const char rcsid[] __RWUNUSED__ = "@@(#)$Id: wrldpipe.c,v 1.10 2001/02/02 11:40:07 katherinet Exp $";



/****************************************************************************
 _rxWorldDevicePluginAttach()
 */

RwBool
_rxWorldDevicePluginAttach(void)
{
    RwBool result = FALSE; /* fail, unless explicitly set TRUE */

    RWFUNCTION(RWSTRING("_rxWorldDevicePluginAttach"));

    /* device-specific set-up... */

    result = TRUE;

    RWRETURN(result);
}

/**
 * \ingroup rpworldnull
 * \page RpMaterialGetDefaultRenderPipelineplatform RpMaterialGetDefaultRenderPipeline (platform-specific) 
 *
 * The default material render pipeline for the NULL driver is empty,
 * as the NULL driver is not meant to render anything.
 *
 * \see RpAtomicGetDefaultInstancePipeline
 * \see \ref RpAtomicGetDefaultInstancePipelineplatform
 * \see RpAtomicGetInstancePipeline
 * \see RpAtomicSetDefaultInstancePipeline
 * \see RpAtomicSetInstancePipeline
 * \see RpMaterialGetDefaultRenderPipeline
 * \see RpMaterialGetRenderPipeline
 * \see RpMaterialSetDefaultRenderPipeline
 * \see RpMaterialSetRenderPipeline
 * \see RpWorldGetSectorInstancePipeline
 * \see RpWorldSetSectorInstancePipeline
 * \see RpWorldSectorGetInstancePipeline
 * \see RpWorldSectorSetInstancePipeline
 * \see RpWorldGetDefaultSectorInstancePipeline
 * \see \ref RpWorldGetDefaultSectorInstancePipelineplatform
 * \see RpWorldSetDefaultSectorInstancePipeline
 *
 */
RwBool
_rpCreatePlatformMaterialPipelines(void)
{
    RxPipeline        *pipe;

    RWFUNCTION(RWSTRING("_rpCreatePlatformMaterialPipelines"));

    pipe = RxPipelineCreate();
    if (pipe)
    {
        RxLockedPipe       *lpipe;

        lpipe = RxPipelineLock(pipe);
        if (NULL != lpipe)
        {
            pipe = RxLockedPipeUnlock(lpipe);

            RWASSERT(NULL != pipe);
            RWASSERT(pipe == lpipe);

            if (pipe != NULL)
            {
                RXPIPELINEGLOBAL(platformMaterialPipeline) = pipe;
                RpMaterialSetDefaultRenderPipeline(pipe);

                RWRETURN(TRUE);
            }
        }

        RxPipelineDestroy(pipe);
    }

    RWRETURN(FALSE);
}

void
_rpDestroyPlatformMaterialPipelines(void)
{
    RWFUNCTION(RWSTRING("_rpDestroyPlatformMaterialPipelines"));

    RpMaterialSetDefaultRenderPipeline(NULL);
    if (NULL != RXPIPELINEGLOBAL(platformMaterialPipeline))
    {
        RxPipelineDestroy(RXPIPELINEGLOBAL(platformMaterialPipeline));
        RXPIPELINEGLOBAL(platformMaterialPipeline) = NULL;
    }

    RWRETURNVOID();
}

/**
 * \ingroup rpworldnull
 * \page RpWorldGetDefaultSectorInstancePipelineplatform RpWorldGetDefaultSectorInstancePipeline (platform-specific) 
 *
 * The default world sector instance pipeline for the NULL driver is empty,
 * as the NULL driver is not meant to render anything.
 *
 * \see RpAtomicGetDefaultInstancePipeline
 * \see \ref RpAtomicGetDefaultInstancePipelineplatform
 * \see RpAtomicGetInstancePipeline
 * \see RpAtomicSetDefaultInstancePipeline
 * \see RpAtomicSetInstancePipeline
 * \see RpMaterialGetDefaultRenderPipeline
 * \see \ref RpMaterialGetDefaultRenderPipelineplatform
 * \see RpMaterialGetRenderPipeline
 * \see RpMaterialSetDefaultRenderPipeline
 * \see RpMaterialSetRenderPipeline
 * \see RpWorldGetSectorInstancePipeline
 * \see RpWorldSetSectorInstancePipeline
 * \see RpWorldSectorGetInstancePipeline
 * \see RpWorldSectorSetInstancePipeline
 * \see RpWorldGetDefaultSectorInstancePipeline
 * \see RpWorldSetDefaultSectorInstancePipeline
 *
 */
RwBool
_rpCreatePlatformWorldSectorPipelines(void)
{
    RxPipeline        *pipe;

    RWFUNCTION(RWSTRING("_rpCreatePlatformWorldSectorPipelines"));

    pipe = RxPipelineCreate();
    if (pipe)
    {
        RxLockedPipe       *lpipe;

        lpipe = RxPipelineLock(pipe);

        if (NULL != lpipe)
        {
            pipe = RxLockedPipeUnlock(lpipe);

            RWASSERT(NULL != pipe);
            RWASSERT(pipe == lpipe);

            if (pipe != NULL)
            {
                RXPIPELINEGLOBAL(platformWorldSectorPipeline) = pipe;
                RpWorldSetDefaultSectorInstancePipeline(pipe);

                RWRETURN(TRUE);
            }
        }

        RxPipelineDestroy(pipe);
    }

    RWRETURN(FALSE);
}

void
_rpDestroyPlatformWorldSectorPipelines(void)
{
    RWFUNCTION(RWSTRING("_rpDestroyPlatformWorldSectorPipelines"));

    RpWorldSetDefaultSectorInstancePipeline(NULL);
    if (NULL != RXPIPELINEGLOBAL(platformWorldSectorPipeline))
    {
        RxPipelineDestroy(RXPIPELINEGLOBAL(platformWorldSectorPipeline));
        RXPIPELINEGLOBAL(platformWorldSectorPipeline) = NULL;
    }

    RWRETURNVOID();
}

/**
 * \ingroup rpworldnull
 * \page RpAtomicGetDefaultInstancePipelineplatform RpAtomicGetDefaultInstancePipeline (platform-specific) 
 *
 * The default atomic instance pipeline for the NULL driver is empty,
 * as the NULL driver is not meant to render anything.
 *
 * \see RpAtomicGetDefaultInstancePipeline
 * \see RpAtomicGetInstancePipeline
 * \see RpAtomicSetDefaultInstancePipeline
 * \see RpAtomicSetInstancePipeline
 * \see RpMaterialGetDefaultRenderPipeline
 * \see \ref RpMaterialGetDefaultRenderPipelineplatform
 * \see RpMaterialGetRenderPipeline
 * \see RpMaterialSetDefaultRenderPipeline
 * \see RpMaterialSetRenderPipeline
 * \see RpWorldGetDefaultSectorInstancePipeline
 * \see RpWorldGetSectorInstancePipeline
 * \see RpWorldSectorGetInstancePipeline
 * \see RpWorldSectorSetInstancePipeline
 * \see RpWorldSetDefaultSectorInstancePipeline
 * \see RpWorldSetSectorInstancePipeline
 * \see \ref RpWorldGetDefaultSectorInstancePipelineplatform
 */
RwBool
_rpCreatePlatformAtomicPipelines(void)
{
    RxPipeline        *pipe;

    RWFUNCTION(RWSTRING("_rpCreatePlatformAtomicPipelines"));

    pipe = RxPipelineCreate();
    if (pipe)
    {
        RxLockedPipe       *lpipe;

        lpipe = RxPipelineLock(pipe);

        if (NULL != lpipe)
        {
            pipe = RxLockedPipeUnlock(lpipe);

            RWASSERT(NULL != pipe);
            RWASSERT(pipe == lpipe);

            if (pipe != NULL)
            {
                RXPIPELINEGLOBAL(platformAtomicPipeline) = pipe;
                RpAtomicSetDefaultInstancePipeline(pipe);

                RWRETURN(TRUE);
            }
        }

        RxPipelineDestroy(pipe);
    }

    RWRETURN(FALSE);
}

void
_rpDestroyPlatformAtomicPipelines(void)
{
    RWFUNCTION(RWSTRING("_rpDestroyPlatformAtomicPipelines"));

    RpAtomicSetDefaultInstancePipeline(NULL);
    if (NULL != RXPIPELINEGLOBAL(platformAtomicPipeline))
    {
        RxPipelineDestroy(RXPIPELINEGLOBAL(platformAtomicPipeline));
        RXPIPELINEGLOBAL(platformAtomicPipeline) = NULL;
    }

    RWRETURNVOID();
}

