
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 2001 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * clmpanim.h
 *
 * Copyright (C) 2001 Criterion Technologies.
 *
 * Original author: Alexandre Hadjadj
 * Reviewed by:
 *
 * Purpose: Handling animations.
 *
 ****************************************************************************/

#ifndef CLMPANIM_H
#define CLMPANIM_H

#include "rwcore.h"
#include "rpworld.h"

#define NUMANIMSEQUENCESMAX (100)

extern RwBool FrameAnimOn;
extern RwBool ClumpHasFrameAnimation;
extern RwBool ClumpIsBoneAndSkinSystem;
extern RwBool FinishedLastSequence;

extern RwInt32 AtomicTotalRotationKeys;
extern RwInt32 AtomicTotalTranslationKeys;

extern RwBool AllAnimsTogether;
extern RwReal FrameAnimSpeed;

extern RwInt32 CurrentAnimSequenceIndex;
extern RwChar *AnimSequenceNames[NUMANIMSEQUENCESMAX];

#ifdef    __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RwFrame *FrameCountKeys(RwFrame *frame, void *data);
extern void ClumpIncrementFrameAnimationSeq(RpClump *clump, RwReal inc);

extern void AnimRestart(RpClump *clump);
extern RwBool AnimClumpInitialize(RpClump *clump);
extern void AnimUpdateClump(RwReal delta);

#ifdef    __cplusplus
}
#endif /* __cplusplus */

#endif /* CLMPANIM_H */

