/* SCEI CONFIDENTIAL
 "PlayStation 2" Programmer Tool Runtime Library  Release 2.0
 */
/* 
 *              Emotion Engine Library Sample Program
 *
 *                      - object handler -
 *
 *                         Version 0.10
 *                           Shift-JIS
 *
 *      Copyright (C) 1998-1999 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *                            object.h
 *               header file of object operation
 *
 *       Version        Date            Design      Log
 *  --------------------------------------------------------------------
 *	0.1		Jul,13,1998	suzu	    1st version
 *	0.2		Dec,23,1999	suzu	    changed for libgraph
 *	0.3		May,13,1999	suzu	    add comment
 */

// The following Japanese comments are in SJIS foramt.
// You can delete Japanese comments as follows:
//		% sed '/^\/\/J/d' [filenam]
//
// RcIuWFNgnhʃwb_t@C
// ۂ̍Wϊ֐͂̃nhČĂяo܂
// ̃t@C vu0 TvvOł͋ʂł

#ifndef _OBJECT_H_
#define _OBJECT_H_

// ---------------------------------------------------------------------------
// 
// 			External includes and constants
// 
// ---------------------------------------------------------------------------
// ȉ̃CN[ht@CKvłBڍׂ̓J[lъeCu
// ̃t@XQƉB	
// The following header file is required 	
#include <eekernel.h>		// kernel definitions
#include <libvu0.h>		// libvu0 definitions
#include <math.h>		// mathematics library
#include <stdlib.h>		// standard I/O


// ~`܂B
// PI
#define PI	3.141421356f	// Pai

// EE ͒Px_܂B̂߂ɒʏ̍֐͒P
// xł܂B{x_ƒPx_̓쑬x͑
// قȂ̂ŒӂKvłB
// single precision utilities
#ifndef OPENGL
#define sqrt(x)	sqrtf(x)	// single precision SQRT
#define sin(x)	sinf(x)		// single precision SIN
#define cos(x)	cosf(x)		// signel procision COS
#endif


// {Iȃf[^^`܂Bł VECTOR ^ MATRIX ^
// `܂Bڍׂ libvu0 ̃hLgQƉB
//	
//	VECTOR		1x4 float z
//	MATRIX		4x4 float z
//
// basic type
typedef sceVu0FVECTOR		VECTOR;
typedef sceVu0FMATRIX		MATRIX;

// ---------------------------------------------------------------------------
// 
// 				SCREEN 
// 
// ---------------------------------------------------------------------------
// XN[WñvpeB`܂B
//
// o	e
//------------------------------------------------------------------------	
// scrz	JXN[܂ł̋BƉpL܂B
// ax, ay	sNZ̃AXyNgw肵܂B
//		640x480 [hł (ax,ay)=(1.0,1.0) w肵܂A
//		640x240 [hł (ax,ay)=(1.0,0.5) ƂȂ܂B
// cx, cy	SlBݖgp
// zmin,zmax	Z obt@̒l̍ŏ^őlBݖgp
// nearz,farz	r[Wnł̍ŋߒlƍŉlBݖgp
// vs		r[WnXN[Wn֕ϊ邽߂̍sB
//		scrz,ax,ay,cx,cy,zmin,zmax,nearz,farz vZ܂
// vc		r[WnNbvWn֕ϊ邽߂̍sB
//		ݖgp
//
// Screen property
typedef struct {
	float	scrz;		// distance to screen
	float	ax, ay;		// aspect ratio
	float	cx, cy;		// center point
	float	zmin, zmax;	// Z-buffer range		
	float	nearz, farz;	// z edge
	MATRIX	vs;		// view-screen matrix
	MATRIX	vc;		// view-clip matrix
} SCREEN;


// ---------------------------------------------------------------------------
// 
// 				VIEW
// 
// ---------------------------------------------------------------------------
//
// r[WñvpeB`܂B
//
// o	e
//------------------------------------------------------------------------	
// yd		[hWnŌJ̋r̕܂B
//		JnʂɕsɒuĂ (0,0,-1,0) ƂȂ܂
// zd		[hWnŌJ̎܂
//		JɌ_ (0,0,0) 悤ɂɂ p J
//		ʒuƂāAzd = (-p[0], -p[1], -p[2], 0) Ƃ܂B 		
// p		[hWnŌJ̈ʒu܂B
// wv		[hWnr[Wnւ̕ϊsB
//		yd, zd, p vZ܂B
// ws		[hWnXN[Wnւ̕ϊsB
//		[J֐ updateView() ŌvZ܂B
// wc		[hWnNbvWnւ̕ϊsB
//		[J֐ updateView() ŌvZ܂B
// Your position property 
typedef struct {
	VECTOR	yd;		// vertical vector (in the world)
	VECTOR	zd;		// eye direction (in the world)
	VECTOR	p;		// standing position
	MATRIX	wv;		// world-view matrix
	MATRIX	ws;		// world-screen matrix
	MATRIX	wc;		// world-clip matrix
} VIEW;

// ---------------------------------------------------------------------------
// 
// 				LIGHT
// 
// ---------------------------------------------------------------------------
// vẐ߂̃vpeB`܂B
// ͕s 3 A_ 1 Ƃł܂B
//
// o	e
//------------------------------------------------------------------------	
// model	fw肵܂B̓IuWFNgnhC
//		^X֐ŎQƂ邱Ƃ҂܂BR̃tB[
//		hQƂȂCX^X֐ɂ͖łB
//		1 CeBOvZsȂ܂B
//		2 s
//		3 ^_B
//		  IuWFNg̑\lƌ̈ʒuxNg
//		  ߁ÃIuWFNgɑ΂Ă͕sƂĈ܂B
//		3 _BȂ̓_vZSĂ̒_ɑ΂čs
//		  ܂B
//
// lp0,lp1,lp2	[hWnŎꂽ̈ʒuB_ɂ̂ݗLB
// ld0,ld1,ld2	[hWnŎꂽ  sɂ̂ݗLB
// c0,  c1, c2	F
// a		FBׂĂ̌ off łĂFZ܂
// nl		[hWnŋLqꂽm[}Cgs 
// lc		CgJ[s

// lighting property
typedef struct {
	int	model;	// light model (0:off, 1:pararell, 2:pseudo spot, 3:spot
	VECTOR	lp0, lp1, lp2;	// light source position (in the world)
	VECTOR	ld0, ld1, ld2;	// light direction       (in the world)
	VECTOR	c0, c1, c2;	// light influence
	VECTOR	a;		// ambient color
	MATRIX	nl;		// world normal-light 
	MATRIX	lc;		// light-color matrix
} LIGHT;

// ---------------------------------------------------------------------------
// 
// 				OBJECT
// 
// ---------------------------------------------------------------------------
// RcIuWFNg̃vpeB`܂B
// OBJECT \̂邱Ƃŕ̃IuWFNghCoiCX^
// X֐j𓝈Iɑ삷邱Ƃł܂B
// evpeB́A \̂ driver oƂĒ`CX^X
// ֐ŎQƂ邱Ƃ҂܂BCX^X֐lQƂ
// Ȃꍇ͖ɂȂ܂B
//
// o	e
//------------------------------------------------------------------------	
// tag		IuWFNg\v~eBuɑ΂ GIFtag
//		[J֐ ObjMakeTag() Ŏw肵܂B
// view	݂̃r[
// light	݂̃Cg
// mw		fi[JjWn烏[hWnւ̕ϊs
// shadow	1 w肳 z = 0 ̖ʂɑ΂hbvVhE
//		sȂ܂B
// clip	1 w肳ƃv~eBuPʂŉʃNbvsȂ
//		܂B
// spec	XyLB1 ȏw肷ƋIȌ򂪕\܂B
// rate	}䗦B̒_i_ƑΒ_j`}Ē_
//		𐶐ꍇɂ̗w肵܂B
// c, c1	_ƑΒ_̃ftHgFw肵܂B_F͂ 
//		rate Ő`}lƂ܂
// cvnt	color-vertex-normal-texture f[^B
//		_f[^ GIFtag ɑXgbvbV҂
//		܂BbV̌ GIFtag  NLOOP tB[h
//		擾܂B܂IuWFNgf[^́A
//	
//			GIFtag
//			(R, G, B, A)  N 
//			(Vx,Vy,Vz,1)  N 
//			(Nx,Ny,Nz,1)  N 
//			(S, T, Q, 1)  N 
//
//		̌`ŋLqĂ̂Ƃ݂Ȃ܂B
//		GIFtag ̃tB[h tag o NLOOP I[o[
//		Cg܂
// cvnt1	Β_B}gpȂꍇ͖łB
// box		EfBO{bNXBbox[0]-box[7] ܂ł 8 _
//		IuWFNgWʑ̂`܂B̓IuWF
// dirver[13]	Path1/Path3 oRăfBXvCXg邽߂̃C
//		X^X֐Bw肷邱Ƃł܂B
//
// object handler
typedef struct {
	qword		tag;		// GIFtag (path3) REFtag (path1)
	VIEW		*view;		// view
	LIGHT		*light;		// light
	MATRIX		*mw;		// model-world matrix
	u_char		shadow;		// indicate shadow (to Z=0 plane)
	u_char		clip;		// clip enable
	u_char		spec;		// specular
	float		rate;		// interpolate rate
	VECTOR		*c;		// fixed color
	VECTOR		*c1;		// counter fixed color  
	VECTOR		*cvnt;		// color-vertex-normal-texture
	VECTOR		*cvnt1;		// countter color-vertex-normal-texture
	VECTOR		*box;		// rounding box
	qword		*(*driver1)();	// path1 driver pointer		
	qword		*(*driver3)();	// path3 driver pointer		
} OBJECT;

// ---------------------------------------------------------------------------
// 
// 				Macros
// 
// ---------------------------------------------------------------------------
// TvŎgp}N`܂BRpC̍œK\ɂ
// Ă͂͏ inline ֐ɒuׂł
// Macros
#define setVector(v,x,y,z,w)	((v)[0]=(x),(v)[1]=(y),(v)[2]=(z),(v)[3]=(w))
#define setVector3(v,x,y,z)	((v)[0]=(x),(v)[1]=(y),(v)[2]=(z))
#define setVectorX(v,x)		((v)[0]=(x))
#define setVectorY(v,y)		((v)[1]=(y))
#define setVectorZ(v,z)		((v)[2]=(z))
#define setVectorW(v,w)		((v)[3]=(w))
#define limit(a, b, c)		((a)<(b))?(b):((c)<(a))?(c):(a)

// ---------------------------------------------------------------------------
// 
// 				Prototypes
// 
// ---------------------------------------------------------------------------
// Ŏgvg^Cv錾łBڍׂ͑Ή\[XR[h̓
// t@CQƉB 
	
// object handler (see object.c)
void objInit(qword *base1, qword *base3);
void objFlush();
void objMakeTag(OBJECT *obj, int abe, int fge, int tme, int iip);
void objDraw(OBJECT *obj);

// utility (see util.c)
void draw_zplane(int width, int step);
void make_mesh(VECTOR *meshv, VECTOR *meshn, int mx, void (*func)());
void map_mesh(OBJECT *obj, VECTOR *meshv, VECTOR *meshn, int mx);
void map_sphere(OBJECT *obj, int width, int step);
void map_cylinder(OBJECT *obj, int width, int step);
void map_corn(OBJECT *obj, int width, int step);
void make_joint_matrix(MATRIX m[], int n, float scale, float theta);

// extern object driver (see obj*.c)
extern qword *objDrvNormal();		// rich driver
extern qword *objDrvSimple();		// simple driver
extern qword *objDrvFast();		// fast driver
extern qword *objDrvFastA();		// fast driver (assmebler version)
extern qword *objDrvPath1Test();	// path1 driver

// prototypes (see sce_pp3.c)
extern void scePP1_Kick(void *addr);
extern void scePP3_Kick(u_int *addr, int qwc);
extern void scePP13_Sync();
extern void updateLight(LIGHT *light);
extern void updateView(SCREEN *screen, VIEW *view);


// for convention
// R[h邽߂Ɉȉ̊ȌL@gp܂BAV{
// Xgɂ define Œuꂽ֐܂B
#define DumpVector		sceVu0DumpVector
#define DumpMatrix		sceVu0DumpMatrix
#define CopyVector		sceVu0CopyVector
#define CopyVectorXYZ		sceVu0CopyVectorXYZ
#ifndef OPENGL
#define Int0Vector		sceVu0FTOI0Vector
#define Int4Vector		sceVu0FTOI4Vector
#define Float0Vector		sceVu0ITOF0Vector
#define Float4Vector		sceVu0ITOF4Vector
#else
#define Int0Vector		sceVu0Int0Vector
#define Float0Vector		sceVu0Float0Vector
#define Int4Vector		sceVu0Int4Vector
#define Float4Vector		sceVu0Float4Vector
#endif

#define ScaleVector		sceVu0ScaleVector
#define ScaleVectorXYZ		sceVu0ScaleVectorXYZ
#define AddVector		sceVu0AddVector
#define SubVector		sceVu0SubVector
#define MulVector		sceVu0MulVector
#define InterVector		sceVu0InterVector
#define InterVectorXYZ		sceVu0InterVectorXYZ
#define DivVector		sceVu0DivVector
#define DivVectorXYZ		sceVu0DivVectorXYZ
#define ClipVector		sceVu0ClipVector
#define InnerProduct		sceVu0InnerProduct
#define OuterProduct		sceVu0OuterProduct
#define Normalize		sceVu0Normalize
#define ApplyMatrix		sceVu0ApplyMatrix
#define UnitMatrix		sceVu0UnitMatrix
#define CopyMatrix		sceVu0CopyMatrix
#define TransposeMatrix		sceVu0TransposeMatrix
#define MulMatrix		sceVu0MulMatrix
#define InversMatrix		sceVu0InversMatrix
#define RotMatrixX		sceVu0RotMatrixX
#define RotMatrixY		sceVu0RotMatrixY
#define RotMatrixZ		sceVu0RotMatrixZ
#define TransMatrix		sceVu0TransMatrix
#define CameraMatrix		sceVu0CameraMatrix
#define NormalLightMatrix	sceVu0NormalLightMatrix
#define LightColorMatrix	sceVu0LightColorMatrix
#define ViewScreenMatrix	sceVu0ViewScreenMatrix
#define ViewClipMatrix		sceVu0ViewClipMatrix
#define DropShadowMatrix	sceVu0DropShadowMatrix
#define ClipScreen		sceVu0ClipScreen
#define ClipAll			sceVu0ClipAll
#define ClampVector		sceVu0ClampVector

#define printf	kprintf

#endif /* _OBJECT_H_ */
