/* SCEI CONFIDENTIAL
 "PlayStation 2" Programmer Tool Runtime Library  Release 2.0
 */
/* 
 *              Emotion Engine Library Sample Program
 *
 *                      - object handler -
 *
 *                         Version 0.10
 *                           Shift-JIS
 *
 *      Copyright (C) 1998-1999 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *                            obfast.c
 *
 *       Version        Date            Design      Log
 *  --------------------------------------------------------------------
 *	0.1		Jul,13,1998	suzu	    1st version
 *	0.2		Dec,23,1999	suzu	    changed for libgraph
 *	0.3		May,13,1999	suzu	    add comment
 */
// IuWFNgnhCX^X̗B
// CX^X֐ɂ͈ȉ̗Ⴊ܂
//
// ----------------------------------------------------------------------
// objnorm.c		@\dWIȃCX^X
// objsimpl.c		@\dȗCX^X
// objfast.c		xdVvȃCX^X
// objfastA.c		xdVvȃCX^XiAZuj
// ----------------------------------------------------------------------
//	
// objfast.c ł͊֐ objDrvFast() `܂B̊֐ł́A
// eXgbvƂ͈̏ȉ̕\܂
//
// cvnt ̍ŏ qword ɂ̓Xgbv̒L^Ă܂
//	| while ((nv = cvnt[0][3]) > 0) {
//	
// ̒lo GIFtag𐶐܂B
//
//	| obj->tag[0] = 0x8000 | nv;
//	| CopyVector((float *)(*pbase++),   (float *)obj->tag);
//
// e_ւ͈̏ȉ̕\܂
//
// 1. J[f[^𐮐փLXgB
//    GIF  RGB ͐^KvƂ܂
//	
//	| Int0Vector(*pbase++, obj->c? obj->c[0]: cvnt[0]);
//
// 2. _f[^ w tB[h 1 w肵̂AϊsKpB
//     _f[^ w tB[hɂ́A}gNX ID L^Ă
//	߂ł 
// 
//	| CopyVector(v, cvnt[nv]);
//	| v[3] = 1;
//	| ApplyMatrix(v, ms, v);
//
// 3. ϊsȂ
//	
//	| DivVectorXYZ(v, v, v[3]);
//
// 4. ʂ𐮐փLXg
//	
//	| Int4Vector(*pbase++, v);
//
#include "object.h"
#ifndef OPENGL
static inline void CopyVector(VECTOR v0, VECTOR v1)
{
	asm ("
	lq    $6,0x0(%1)
	sq    $6,0x0(%0)
	": : "r" (v0) , "r" (v1):"$6");
}
#endif

qword *objDrvFast(qword *pbase, OBJECT *obj) 
{
	int	i, nv;
	VECTOR	v;
	VECTOR	*cvnt;
	MATRIX	ms; 

	// update matrix
	MulMatrix(ms, obj->view->ws,  obj->mw[0]);

	// main loop
	cvnt  = obj->cvnt;
	while ((nv = cvnt[0][3]) > 0) {
			
		// set tag
		obj->tag[0] = 0x8000 | nv;
		CopyVector((float *)(*pbase++),   (float *)obj->tag);

		// project each vertex
		cvnt++;
		for (i = 0; i < nv; i++, cvnt++) {

			// color
			Int0Vector(*pbase++, obj->c? obj->c[0]: cvnt[0]);
	
			// vertex
			CopyVector(v, cvnt[nv]);
			v[3] = 1;

			// rot-trans-pers
			ApplyMatrix(v, ms, v);

			// project
			DivVectorXYZ(v, v, v[3]);

			// output
			Int4Vector(*pbase++, v);

		}
		cvnt  += 3*nv;
	}

	return(pbase);
}
