/****************************************************************************
 *                                                                          *
 * Module  : skywrins.c                                                     *
 *                                                                          *
 * Purpose : Custom instance stages for Playstation II [in a previous life] *
 *                                                                          *
 ****************************************************************************/

#include "baasm.h"
#include "skyinst.h"

#if (!defined(DOXYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: skywrins.c,v 1.15 2001/04/02 13:58:00 iestynb Exp $";
#endif /* (!defined(DOXYGEN)) */

/* We have an array to make things easier */
/* For now we ignore a lot of these, though in future we might have more */

#define SKYVU1TRANSFORMSALIGN __attribute__ ((aligned(64)))

#define OLDGENERICx

void* skyVU1Transforms[VU1CODEARRAYSIZE] SKYVU1TRANSFORMSALIGN =
{

#ifdef OLDGENERIC
#define NONCULLGENERICx

&vu1nfStTrans,    /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1StTrans,      /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1StcTrans,     /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1StcTrans,     /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSTRI  */
&vu1transnc,      /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1transnc,      /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1trans,        /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1transf,       /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSTRI  */

&vu1isoStcTrans,  /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1isoStcTrans,  /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1isoStcTrans,  /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1isoStcTrans,  /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSTRI  */
&vu1isotrans,     /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1isotrans,     /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1isotrans,     /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1isotrans,     /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSTRI  */

&vu1transl,       /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1transl,       /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSLINE */

&vu1isotransl,    /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1isotransl,    /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSLINE */

#else

#ifdef NONCULLGENERIC

&vu1GenericPRS,   /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1GenericPRS,   /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSTRI  */

&vu1GenericPRL,   /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSTRI  */
&vu1GenericPRL,   /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSTRI  */

&vu1SegmentsPRS,  /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1SegmentsPRS,  /* TRANSPER, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSLINE */

&vu1SegmentsPRL,  /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSSTRIP, TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSSTRIP, TRANSCLIP, TRANSFOG,  TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSNFOG, TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSLIST,  TRANSNCL,  TRANSFOG,  TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSNFOG, TRANSLINE */
&vu1SegmentsPRL,  /* TRANSISO, TRANSLIST,  TRANSCLIP, TRANSFOG,  TRANSLINE */

#else /* NONCULLGENERIC */

&vu1GenericPRS,   /* TRANSTRI,  TRANSPER, TRANSNCULL */
&vu1CullFacePRS,  /* TRANSTRI,  TRANSPER, TRANSCULL */
&vu1GenericPRL,   /* TRANSTRI,  TRANSISO, TRANSNCULL  */
&vu1nullTrans,    /* NOT DONE YET: &vu1CullFacePRL,*/   /* TRANSTRI,  TRANSISO, TRANSCULL  */

&vu1SegmentsPRS,  /* TRANSLINE, TRANSPER, TRANSNCULL */
&vu1nullTrans,    /* No culling for lines */
&vu1SegmentsPRS,  /* TRANSLINE, TRANSISO, TRANSNCULL */
&vu1nullTrans,    /* No culling for lines */

&vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
&vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,

&vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
&vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,

&vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
&vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,

#endif /* NONCULLGENERIC */

#endif
};
