#ifndef EFFECTPIPESOPENGL_H
#define EFFECTPIPESOPENGL_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

/*===========================================================================*
 *--- Defines ---------------------------------------------------------------*
 *===========================================================================*/

/*---------------------------------------------------------------------------*
 *    BumpMap, EnvMap, Dual, get macros                                      *
 *---------------------------------------------------------------------------*/
#define MATFXOPENGLBUMPMAPGETDATA(material, pass)                       \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *) material) +                                        \
        MatFXMaterialDataOffset)))->data[pass].data.bumpMap)

#define MATFXOPENGLBUMPMAPGETCONSTDATA(material, pass)                  \
  &((*((rpMatFXMaterialData *const *)                                   \
       (((const RwUInt8 *) material) +                                  \
        MatFXMaterialDataOffset)))->data[pass].data.bumpMap)

#define MATFXOPENGLENVMAPGETDATA(material, pass)                        \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *) material) +                                        \
        MatFXMaterialDataOffset)))->data[pass].data.envMap)

#define MATFXOPENGLENVMAPGETCONSTDATA(material, pass)                   \
  &((*((rpMatFXMaterialData *const *)                                   \
       (((const RwUInt8 *) material) +                                  \
        MatFXMaterialDataOffset)))->data[pass].data.envMap)

#define MATFXOPENGLDUALGETDATA(material, pass)                          \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *) material) +                                        \
        MatFXMaterialDataOffset)))->data[pass].data.dual)

#define MATFXOPENGLDUALGETCONSTDATA(material, pass)                     \
  &((*((rpMatFXMaterialData *const *)                                   \
       (((const RwUInt8 *) material) +                                  \
        MatFXMaterialDataOffset)))->data[pass].data.dual)


/*===========================================================================*
 *--- Types -----------------------------------------------------------------*
 *===========================================================================*/
struct MatFXDualData
{
    RwTexture          *texture;
    RwBlendFunction     srcBlendMode;
    RwBlendFunction     dstBlendMode;
    /*--- device specific ---*/
};

struct MatFXBumpMapData
{
    RwFrame   *frame;
    RwTexture *texture;
    RwTexture *bumpTexture;
    RwReal    coef;
    RwReal    invBumpWidth;
};


/*===========================================================================*
 *--- Public Global Variables -----------------------------------------------*
 *===========================================================================*/

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

#if (defined (OPENGL_DRVMODEL_H))

extern RwGlExt      gl;

#endif /* (defined (OPENGL_DRVMODEL_H)) */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/*===========================================================================*
 *--- Functions -------------------------------------------------------------*
 *===========================================================================*/

#endif /* EFFECTPIPESOPENGL_H */


