/*----------------------------------------------------------------------*/
/*-                             Includes                               -*/
/*----------------------------------------------------------------------*/
#include <rpdbgerr.h>
#include <archive/rpmatfx310.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_BumpMapping/bumpPipe.h"
#include "SKY2_BumpMapping/stddata.h"

#if (!defined(DOXYGEN))
static const char rcsid[] __RWUNUSED__ = 
    "@@@@(#)$Id: bumpPipe.c,v 1.11 2001/09/26 10:48:08 johns Exp $";
#endif /* (!defined(DOXYGEN)) */

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/

#define RWALIGN_skyBumpMapTransforms \
        RWALIGN(skyBumpMapTransforms, rpMATFXALIGNMENT)

matFXVUcode 
RWALIGN_skyBumpMapTransforms =
{
    &BumpMappingPRS, &vu1nullTrans,
    &BumpMappingPRL, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,   &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*----------------------------------------------------------------------*/
/*-                                Functions                           -*/
/*----------------------------------------------------------------------*/
RwBool
_rpMatFXBumpInstanceCallBack( void **clusterData,
                              RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh                      *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec = (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData    *materialData = 
                (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Bump map ----------------------------------*/
    RwTexture *texture = (RwTexture *) NULL;
    RwReal     bumpCoef;

    RWFUNCTION(RWSTRING("_rpMatFXBumpInstanceCallBack"));
    RWASSERT(mesh);
    RWASSERT(materialData);

    bumpCoef = materialData->data[rpSECONDPASS].data.bumpMap.coef *
        materialData->data[rpSECONDPASS].data.bumpMap.invBumpWidth;
    texture = materialData->data[rpSECONDPASS].data.bumpMap.texture;
    RWASSERT(texture);

    /*------- bumpMap texture upload ------------*/
    if (NULL == texture)
    {
        texture = mesh->mesh->material->texture;
    }
 	if (NULL != texture)
    {
   		_rpMatFXUploadTexture(texture, dmaSessionRec, mesh);
   	}
    {
        RwUInt128           ltmp = 0;
        RwUInt64            tmp, tmp1;

        /*------ DMA data transfer --------------*/
        sweFinaliseOpenLocalPkt((int) (SWE_PKT_DMA_MODE_CHAIN_TTE |
                                       SWE_PKT_LOCAL |
                                       SWE_PKT_VU1 |
                                       SWE_PKT_CIRCALLOC), /**/ -12 /**/);
        if (!sweLocalPacket)
        {
            RWRETURN(FALSE);
        }                                       
        tmp  = ((1l << 28)      | (/**/ 10 /**/));
        tmp1 = ((((0x6cl << 24) | (/**/ 10 /**/ << 16) |
               ((long) (pipeASymbStaticBumpDataStart))) << 32) |
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Emboss Bump Data --------------*/
        tmp  = (*(const RwUInt32 *) &bumpCoef);
        tmp1 = (*(const RwUInt32 *) &matFXBumpFarPlane);
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) &matFXBumpScale));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag2 ------------*/
        tmp  = /* NLOOP */ 2l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000002l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1,  0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag1 ------------*/
        tmp  = /* NLOOP */ 2l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000048l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1,  0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------ Bump Map matrix ----------------------*/
        ltmp = *((u_long128 *) & (matFXBumpMatrix.right));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.up));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.at));
        SWEADDCONTFAST(ltmp);

        /*------- Terminate the DMA with an interrupt -------*/
        MAKE128(ltmp, 0l, (0xfl << 28));
        SWEADDCONTFAST(ltmp);

        /*---------------------------------------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }
    RWRETURN(TRUE);
}
