/*
 * Skin plug-in
 */

/****************************************************************************
 *                                                                          *
 *  Module  :   SkinBumpPipe.c                                               *
 *                                                                          *
 *  Purpose :   Skin Bump mapping pipeline for PS2                          *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */
#include <rpdbgerr.h>
#include <archive/rpmatfx310.h>

/* #include <rpskin.h> */
#include <archive/rpskin310.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_SkinBumpMapping/stddata.h"
#include "SKY2_SkinBumpMapping/skinBumpPipe.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skySkinBumpMapTransforms, rpMATFXALIGNMENT) =
{
    &SkinBumpMappingPRS, &vu1nullTrans,
    &SkinBumpMappingPRL, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*----------------------------------------------------------------------*/
/*-                                Functions                           -*/
/*----------------------------------------------------------------------*/
RwBool
_rpMatFXSkinBumpInstanceCallBack( void **clusterData,
                                  RwUInt32 __RWUNUSED__ numClusters )
{
    /*---------------- Pipe --------------------------------------*/
    RxPS2Mesh                      *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec = (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData *materialData    =
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /*---------------- Skin --------------------------------------*/
    RpAtomic  *atomic     = dmaSessionRec->sourceObject.atomic;
    RpSkin    *skin       = *MatFXSkinAtomicGetData(atomic);
    RwUInt32  numMatrices = MatFXSkinGetNumBones(skin);
    RwReal    *destMBI    = (RwReal *)(clusterData[2]);
    RwInt32   DMAstorage  = 0;
    RwMatrix  *pMBA       = (RwMatrix *)NULL;
    /*---------------- Bump --------------------------------------*/
    RwReal    bumpCoef;
    RwTexture *texture;

    RWFUNCTION(RWSTRING("_rpMatFXSkinBumpInstanceCallBack"));
    RWASSERT(NULL != mesh);
    RWASSERT(NULL != dmaSessionRec);
    RWASSERT(NULL != destMBI);
    RWASSERT(NULL != atomic);
    RWASSERT(NULL != skin);

    bumpCoef = materialData->data[rpSECONDPASS].data.bumpMap.coef *
               materialData->data[rpSECONDPASS].data.bumpMap.invBumpWidth;
    texture = materialData->data[rpSECONDPASS].data.bumpMap.texture;
    RWASSERT(texture);

    /* Do we have a bumpMap texture? */
    if (NULL == texture)
    {
        texture = mesh->mesh->material->texture;
    }
 	if (NULL != texture)
    {
   		_rpMatFXUploadTexture(texture, dmaSessionRec, mesh);
   	}

    /*------------ Skin weights and indices instancing -----------*/
    if (dmaSessionRec->serialNum != ((RwUInt32 *) (*(mesh->cacheEntryRef) + 1))[3])
    {
        MatFXSkinWeightsInstancing(mesh->mesh, skin, destMBI);
    }

    /*----------------- Bones matrices uploading -----------------*/
    if(0 == mesh->meshNum)
    {
        pMBA           = MatFXSkinMatrixUpdating(atomic, skin);
        RWASSERT(NULL != pMBA);
        DMAstorage     = numMatrices * 4;
    }

    /*----------------- DMA data Upload --------------------------*/
    {
        RwUInt128  ltmp = 0;
        RwUInt64   tmp, tmp1;

        /*---------------- DMA packet -----------------------*/
        sweFinaliseOpenLocalPkt((int) (SWE_PKT_DMA_MODE_CHAIN_TTE |
                                       SWE_PKT_LOCAL |
                                       SWE_PKT_VU1 |
                                       SWE_PKT_CIRCALLOC),
                                       /**/ -(12 + DMAstorage) /**/);
        if (!sweLocalPacket)
        {
            RWRETURN(FALSE);
        }
        tmp  = ((1l << 28)      |  (/**/ DMAstorage + 10 /**/));
        tmp1 = ((((0x6cl << 24) | ((/**/ DMAstorage + 10 /**/) << 16) |
               ((long) (pipeASymbSkinStaticBumpDataStart))) << 32)    |
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        /*------------------ Emboss Bump Data --------------*/
        tmp  = (*(const RwUInt32 *) &bumpCoef);
        tmp1 = (*(const RwUInt32 *) &matFXBumpFarPlane);
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) &matFXBumpScale));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag2 ------------*/
        tmp  = /* NLOOP */ 2l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000002l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1,  0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag1 ------------*/
        tmp  = /* NLOOP */ 2l
             | /* EOP   */ (1l << 15)
             | /* PRE   */ (0l << 46)
             | /* FLG   */ (0l << 58)
             | /* NREG  */ (1l << 60);
        MAKE128(ltmp, 0xel, tmp);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_ALPHA_1, 0x8000000048l);
        SWEADDCONTFAST(ltmp);
        MAKE128(ltmp, GS_TEST_1,  0x50002l);
        SWEADDCONTFAST(ltmp);

        /*------------ Bump Map matrix ----------------------*/
        ltmp = *((u_long128 *) & (matFXBumpMatrix.right));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.up));
        SWEADDCONTFAST(ltmp);
        ltmp = *((u_long128 *) & (matFXBumpMatrix.at));
        SWEADDCONTFAST(ltmp);

        /*-------- Upload Skin matrices ---------------------*/
        if(DMAstorage)
        {
            RwUInt32  i;
            for (i = 0; i < numMatrices; i++)
            {
                ltmp = *((u_long128 *) & pMBA->right.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->up.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->at.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->pos.x);
                SWEADDCONTFAST(ltmp);
                pMBA++;
            }
        }

        /*------- Terminate the DMA with an interrupt -------*/
        MAKE128(ltmp, 0l, (0xfl << 28));
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }
    RWRETURN(TRUE);
}
