#ifndef EFFECTPIPESXBOX_H
#define EFFECTPIPESXBOX_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/

#include <rwcore.h>
#include <rpworld.h>

#define NUMBLENDMODES   12

#if !defined(WIN_OSTYPES_H) /* don't include this in NULLXBOX builds! */

#include <xtl.h>
#include <d3d8.h>
extern D3DBLEND _RwXbDualPassConvTable[NUMBLENDMODES];
#endif /* !defined(NULL_XBOX)*/


/*===========================================================================*
 *--- Defines ---------------------------------------------------------------*
 *===========================================================================*/
#define SMALL_FLOAT 0.0001f

#define COLORSCALAR 0.003921568627450980392156862745098f    /* 1.0f/ 255.0f */

#define MATFXXBOXENVMAPGETDATA(material)                                \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *)material) +                                         \
        MatFXMaterialDataOffset)))->data[rpSECONDPASS].data.envMap)

#define MATFXXBOXBUMPMAPGETDATA(material)                                \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *)material) +                                         \
        MatFXMaterialDataOffset)))->data[rpSECONDPASS].data.bumpMap)

#define MATFXXBOXDUALPASSGETDATA(material)                                \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *)material) +                                         \
        MatFXMaterialDataOffset)))->data[rpSECONDPASS].data.dual)

#define MATFXXBOXBUMPENVMAPGETDATA(material)                                \
  &((*((rpMatFXMaterialData **)                                         \
       (((RwUInt8 *)material) +                                         \
        MatFXMaterialDataOffset)))->data[rpTHIRDPASS].data.envMap)


#define IGNORED_XBOX            0

#define MAX_BUMP_TEXTURE_SHIFT 0.01f
#define MAX_SHIFT 0.0045f

/*===========================================================================*
 *--- Types -----------------------------------------------------------------*
 *===========================================================================*/
struct MatFXDualData
{
    RwTexture          *texture;
    RwBlendFunction     srcBlendMode;
    RwBlendFunction     dstBlendMode;

    /*--- device specific ---*/
};

struct MatFXBumpMapData
{
    RwFrame   *frame;
	RwTexture *texture;
	RwTexture *bumpTexture;
    RwReal    coef;
    RwReal    invBumpWidth;
	RwInt32	  vbStride;	
	void      *tex2;
	RwUInt32  bumpVertexShader;
};

/*===========================================================================*
 *--- Public Global Variables -----------------------------------------------*
 *===========================================================================*/


/*===========================================================================*
 *--- Functions -------------------------------------------------------------*
 *===========================================================================*/

extern void _rwXbRenderStateTexture(RwTexture *texture);
extern void _rwXbRenderStateSetTexture(RwTexture *texture, RwInt32 stage);

extern void
_rwXbMatFXRenderStateTexture(RwTexture *texture, RwInt32 stage);

#endif /* EFFECTPIPESXBOX_H */
