/****************************************************************************
 *                                                                          *
 *  Module  :   patchsky.h                                                  *
 *                                                                          *
 *  Purpose :                                                               *
 *                                                                          *
 ****************************************************************************/

#ifdef SKY2_DRVMODEL_H

#ifndef PATCHSKY_H
#define PATCHSKY_H

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

/* RW includes */
#include "rpplugin.h"
#include <rpdbgerr.h>
#include <rwcore.h>
#include <rpworld.h>

/****************************************************************************
 Local Defines
 */
#define RPPATCHNUMQWORD    1
#define RPPATCHGEMNUMQWORD 17

/****************************************************************************
 Globals (across program)
 */

extern long FP_nulltransform __attribute__ ((section(".vudata")));
extern long FP_Generic __attribute__ ((section(".vudata")));

typedef struct rpPatchSkyGlobals RpPatchSkyGlobals;

struct rpPatchSkyGlobals
{
    void               *vucode[VU1CODEARRAYSIZE];
    void               *GEMvucode[VU1CODEARRAYSIZE];
};

/****************************************************************************
 Function prototypes
 */

#ifdef __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

    extern RxPipeline  *_rpPatchPipelineCreate(void);

#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* PATCHSKY_H */

#endif                          /* SKY2_DRVMODEL_H */
