#ifndef _NODED3D8PATCHATOMICINSTANCE_H
#define _NODED3D8PATCHATOMICINSTANCE_H
/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/

#include <d3d8.h>

#include <rwcore.h>
#include <rpworld.h>

#include "rppatch310.h"

#include "patchexp.h"

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

typedef struct RpPatchD3D8Atomic RpPatchD3D8Atomic;
struct RpPatchD3D8Atomic
{
    RwUInt16    serialNumber; /* Serial # - combination of elements contributing to
                         * instanced data.  Enables us to detect when a
                         * re-instance is necessary.
                         */
    RwUInt16    numMeshes;  /* The number of meshes.        */
    RwInt32     res;        /* Resolution of the facetting. */
};

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RxNodeDefinition *
RxNodeDefinitionGetD3D8PatchAtomicInstance(void);

/* external functions */
extern void 
_rwD3D8AtomicDefaultLightingCallback(void *object);

extern RwBool
_rxD3D8VertexBufferManagerCreate(RwUInt32 fvf,
                               RwUInt32 size,
                               void **vertexBuffer,
                               RwUInt32 *baseIndex);

extern void
_rxD3D8VertexBufferManagerDestroy(RwUInt32 fvf,
                                  RwUInt32 size,
                                  void *vertexBuffer,
                                  RwUInt32 baseIndex);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _NODED3D8PATCHATOMICINSTANCE_H */
