
/****************************************************************************
 Includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "rpplugin.h"
#include <rwcore.h>
#include <rpworld.h>
#include <rpdbgerr.h>

/****************************************************************************
 External variables
 */
extern RwImage     *pvsImage, *pvsZImage;

#if (!defined(NO_PVS_CREATE))

/****************************************************************************
 *                                                                          *
 *  Module  :   pvsrendhi.c                                                 *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

#include "fastflit.h"
#include "pvsrendhi.h"

/****************************************************************************
 Local variables
 */

/**********************************************************************/

#define REALPROXY
#define INTERP_COUNT_REALP  0
#define INTERP_COUNT_REAL   1
#define INTERP_COUNT_FIXED  0

#define TRIDECL             RpWorldSector **scanline; \
							RwReal *zscanline; \
							RpWorldSector *fill;
#define TRISETUP(Y)         sb.scanline = (RpWorldSector **)(RwImageGetPixels(pvsImage) + Y * RwImageGetStride(pvsImage)); \
                            sb.zscanline = (RwReal *)(RwImageGetPixels(pvsZImage) + Y * RwImageGetStride(pvsZImage));
#define TRIDY               sb.scanline += RwImageGetStride(pvsImage)>>2; \
							sb.zscanline += RwImageGetStride(pvsZImage)>>2;

#define SCANDECL            static RpWorldSector **scan; static RwReal *zscan;

/* We know the arg is "xstart", so we force a clamp here */
#define SCANSETUP(X)        (xstart<0?(xstart=0):xstart);  \
                            scan = (sb.scanline + ((X<0)?0:(X))); \
                            zscan = (sb.zscanline + ((X<0)?0:(X)));

/* We also clamp width, incase of duff rights */
#define SEGDECL             if (width+xstart>128) width = 128-xstart;
#define SEGBEGIN(W)
#define SEGPIXEL            if (sb.seg_v.part.r[0] > *zscan) \
				            { \
								*zscan = sb.seg_v.part.r[0]; \
                                *scan = sb.fill; \
				            } \
							scan++; zscan++;
#define SEGEND

#include "prolog.ren"
void
_RpPVSRenderTriangleHi(RwInt32 vert1, RwInt32 vert2, RwInt32 vert3,
                       RpWorldSector * spSect)
{
    RWFUNCTION(RWSTRING("_RpPVSRenderTriangleHi"));

    sb.fill = spSect;

    edge[0].x = RWIM2DVERTEXGetScreenX(RWIM2DVERTEXGet(vert1));
    edge[0].y = RWIM2DVERTEXGetScreenY(RWIM2DVERTEXGet(vert1));
    edge[0].v.all[0] = RWIM2DVERTEXGetRecipCameraZ(RWIM2DVERTEXGet(vert1));

    edge[1].x = RWIM2DVERTEXGetScreenX(RWIM2DVERTEXGet(vert2));
    edge[1].y = RWIM2DVERTEXGetScreenY(RWIM2DVERTEXGet(vert2));
    edge[1].v.all[0] = RWIM2DVERTEXGetRecipCameraZ(RWIM2DVERTEXGet(vert2));

    edge[2].x = RWIM2DVERTEXGetScreenX(RWIM2DVERTEXGet(vert3));
    edge[2].y = RWIM2DVERTEXGetScreenY(RWIM2DVERTEXGet(vert3));
    edge[2].v.all[0] = RWIM2DVERTEXGetRecipCameraZ(RWIM2DVERTEXGet(vert3));

    /* NB RW generates duff vertex positions sometimes... */
    if (edge[0].x < (RwReal) (0) || edge[0].x > (RwReal) (128))
    {
        RWRETURNVOID();
    }
    if (edge[0].y < (RwReal) (0) || edge[0].y > (RwReal) (128))
    {
        RWRETURNVOID();
    }
    if (edge[1].x < (RwReal) (0) || edge[1].x > (RwReal) (128))
    {
        RWRETURNVOID();
    }
    if (edge[1].y < (RwReal) (0) || edge[1].y > (RwReal) (128))
    {
        RWRETURNVOID();
    }
    if (edge[2].x < (RwReal) (0) || edge[2].x > (RwReal) (128))
    {
        RWRETURNVOID();
    }
    if (edge[2].y < (RwReal) (0) || edge[2].y > (RwReal) (128))
    {
        RWRETURNVOID();
    }

#include "body.ren"
    RWRETURNVOID();
}

#endif /* (!defined(NO_PVS_CREATE)) */
