/****************************************************************************
 *                                                                          *
 *  Module  :   pvsrendlo.c                                                    *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <rwcore.h>
#include <rwworld.h>

#include "fastflit.h"

/****************************************************************************
 External variables
 */
extern RwImage *pvsImage, *pvsZImage;

/****************************************************************************
 Local variables
 */

/**********************************************************************/

#define REALPROXY
#define INTERP_COUNT_REALP  0
#define INTERP_COUNT_REAL   1
#define INTERP_COUNT_FIXED  0

#define TRIDECL             RwWorldSector **scanline; \
							RwReal *zscanline; \
							RwWorldSector *fill;
#define TRISETUP(Y)         sb.scanline = (RwWorldSector **)(RwImageGetPixels(pvsImage) + Y * RwImageGetStride(pvsImage)); \
                            sb.zscanline = (RwReal *)(RwImageGetPixels(pvsZImage) + Y * RwImageGetStride(pvsZImage));
#define TRIDY               sb.scanline += RwImageGetStride(pvsImage)>>2; \
							sb.zscanline += RwImageGetStride(pvsZImage)>>2;

#define SCANDECL            static RwWorldSector **scan; static RwReal *zscan;
#define SCANSETUP(X)        scan = (sb.scanline + X); \
                            zscan = (sb.zscanline + X);

#define SEGDECL             
#define SEGBEGIN(W)
#define SEGPIXEL            if (sb.seg_v.part.r[0] < *zscan) \
				            { \
								*zscan = sb.seg_v.part.r[0]; \
                                *scan = sb.fill; \
				            } \
							scan++; zscan++;
#define SEGEND

#include "prolog.ren"
void
_RpPVSRenderTriangleLo(RwInt32 vert1, RwInt32 vert2, RwInt32 vert3, RwWorldSector *spSect)
{

	sb.fill = spSect;

    edge[0].x = RWIM2DVERTEXGetScreenX(RWIM2DVERTEXGet(vert1));
    edge[0].y = RWIM2DVERTEXGetScreenY(RWIM2DVERTEXGet(vert1));
    edge[0].v.all[0] = RWIM2DVERTEXGetScreenZ(RWIM2DVERTEXGet(vert1));

    edge[1].x = RWIM2DVERTEXGetScreenX(RWIM2DVERTEXGet(vert2));
    edge[1].y = RWIM2DVERTEXGetScreenY(RWIM2DVERTEXGet(vert2));
    edge[1].v.all[0] = RWIM2DVERTEXGetScreenZ(RWIM2DVERTEXGet(vert2));

    edge[2].x = RWIM2DVERTEXGetScreenX(RWIM2DVERTEXGet(vert3));
    edge[2].y = RWIM2DVERTEXGetScreenY(RWIM2DVERTEXGet(vert3));
    edge[2].v.all[0] = RWIM2DVERTEXGetScreenZ(RWIM2DVERTEXGet(vert3));

#include "body.ren"
}
