
/****************************************************************************
 *
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : fieldrec.h
 *                                                                         
 * Purpose : Used to keep track of which field in which type of 
 *           node is being parsed. 
 *
 ****************************************************************************/

#ifndef UNEXPOSEDFIELDREC_H
#define UNEXPOSEDFIELDREC_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"
#include "vrmlnodetype.h"
#include "llinklist.h"

/****************************************************************************
 Global Types
 */

/*
 This is used to keep track of which field in which type of node is being
 parsed.  Field are nested (nodes are contained inside MFNode/SFNode fields)
 so a stack of these is needed:
*/
typedef struct FieldRec FieldRec;
struct FieldRec
{
    VrmlNodeType *nodeType;
    AbstractNode *abstractNode;
    AbstractField *abstractField;
    /*const */ char *fieldName;
    LLinkList fieldValueList;
    int type;
};



/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

    RwBool FieldRecOpen(void);
    void FieldRecClose(void);

    FieldRec *FieldRec_Create(void);
    void FieldRec_Destroy(FieldRec * fr);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* UNEXPOSEDFIELDREC_H */
