
/****************************************************************************
 *    
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1998 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Material.c
 *                                                                         
 * Purpose : Keeps a record of all the created materials
 *          
 ****************************************************************************/

#ifndef MATERIAL_H
#define MATERIAL_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "types.h"
#include "abstractnode.h"

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

    VRMLBool            Material_Init(void);
    void            Material_Destroy(void);
    VRMLBool            Material_SetCurrent(RpMaterial * material);
    int             Material_GetCurrentIndex(void);
    RpMaterial     *Material_GetCurrent(void);
    int             Material_GetWhiteIndex(void);
    RpMaterial     *Material_GetWhite(void);
    VRMLBool            Material_CopyList(RpMaterialList * materialList);
    VRMLBool            Material_IsCurrentTextured(void);
    void            Material_SetDefault(void);

/* new stuff to impleament proper pre-lighting */
    RwBool          Material_IsSet(void);
    void            Material_SetCurrentEmissiveColor(sfcolor * sfc);
    sfcolor        *Material_GetCurrentEmissiveColor(void);
    void            Material_SetMatNodeFlag(RwBool flag);
    RwBool          Material_GetMatNodeFlag(void);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* MATERIAL_H */
