#ifndef _NODED3D8PATCHATOMICINSTANCE_H
#define _NODED3D8PATCHATOMICINSTANCE_H
/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/

#include <d3d8.h>

#include <rwcore.h>
#include <rpworld.h>

#include "rppatch.h"

#include "patchexpander.h"

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*
 * The refinement node generates new vertices and so has to interpolate
 * per-vertex attributes from the original set of vertices to generate
 * values for the generated vertices. It can (barycentrically)
 * interpolate any number of additional 'passes' of UVs or RGBAs,
 * provided that:
 * (a) these extra clusters are added by the app at pipeline construction
 *     time through the use of RxPipelineNodeRequestCluster(),
 * (b) the extra UVs/RGBAs are the last clusters added to the node, and
 * (c) all the UVs come before the RGBAs (and there are no other cluster
 *     types sprinkled in amongst the UVs/RGBAs)
 */
struct RpNodePatchData
{
    RwBool      patchOn;                                /* patchOn       */
    RwInt32     numExtraUVs;                            /* numExtraUVs   */
    RwInt32     numExtraRGBAs;                          /* numExtraRGBAs */
    RxD3D8AllInOneRenderCallBack    renderCallback;     /* Render callback */
};
typedef struct RpNodePatchData RpNodePatchData;

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RxNodeDefinition *
RxNodeDefinitionGetD3D8PatchAtomicInstance(void);

/* external plugin functions */
extern RwBool
_rwD3D8PatchPipelineNodeInitFn( RxPipelineNode *self );

/* external world functions */
extern void 
_rwD3D8AtomicDefaultLightingCallback(void *object);

extern RwBool
_rxD3D8VertexBufferManagerCreate(RwUInt32 fvf,
                               RwUInt32 size,
                               void **vertexBuffer,
                               RwUInt32 *baseIndex);

extern void
_rxD3D8VertexBufferManagerDestroy(RwUInt32 fvf,
                                  RwUInt32 size,
                                  void *vertexBuffer,
                                  RwUInt32 baseIndex);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _NODED3D8PATCHATOMICINSTANCE_H */
