#ifndef PATCHATOMIC_H
#define PATCHATOMIC_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rppatch.h"

#include "patchlod.h"
#include "patchmesh.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/
typedef struct PatchAtomicData PatchAtomicData;
struct PatchAtomicData
{
    PatchAtomicLod lod;
    PatchMesh *patchMesh;
};

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern void *
_rpPatchAtomicConstructor( void *object,
                           RwInt32 offset,
                           RwInt32 size );
extern void *
_rpPatchAtomicDestructor( void *object,
                          RwInt32 offset,
                          RwInt32 size );
extern void *
_rpPatchAtomicCopy( void *dstObject,
                    const void *srcObject,
                    RwInt32 offset,
                    RwInt32 size );
extern RwInt32
_rpPatchAtomicGetSize( const void *atomic,
                       RwInt32 offset,
                       RwInt32 size );
extern RwStream *
_rpPatchAtomicRead( RwStream *stream,
                    RwInt32 length,
                    void *atomic,
                    RwInt32 offset,
                    RwInt32 size );

extern RwStream *
_rpPatchAtomicWrite( RwStream *stream,
                     RwInt32 length,
                     const void *atomic,
                     RwInt32 offset,
                     RwInt32 size );

extern RwBool
_rpPatchAtomicAlways( void *object,
                      RwInt32 offset,
                      RwInt32 size );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PATCHATOMIC_H */
