/*===========================================================================*
 *-                                                                         -*
 *-  Module  :   G2_SkinBPatchNode.c                                        -*
 *-                                                                         -*
 *-  Purpose :   Hybrid Patch Skin PipeLine for Playstation II.             -*
 *-              PS2 Manager PowerPipe version.                             -*
 *-                                                                         -*
 *===========================================================================*/

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "rppatch.h"
#include "rpskin.h"

#include "patchskyskin.h"
#include "patchsky.h"
#include "patch.h"
#include "patchatomic.h"
#include "patchgeometry.h"

#include "G2_SkinBPatch/G2_SkinBPatchNode.h"
#include "G2_SkinBPatch/G2_SkinBPatchData.h"

#include "../../plugin/skin2/skin.h"

#include "../../driver/sky2/baasm.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/
PatchSkyTransforms _rpPatchSkySkinBPatchTransforms;

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: G2_SkinBPatchNode.c,v 1.10 2001/09/24 13:54:17 johns Exp $";
#endif /* (!defined(DXOYGEN)) */

/*===========================================================================*
 *--- Local Defines ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local functions -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/

/*****************************************************************************
 - _rxPipelineNodePS2SkinBPatchPS2ManagerInstanceCallBack
 - Ps2 manager instance call back for rendering generation 2 bezier patches.
 - Inputs :   clusterData - Clusters
              numClusters - Number of cluster
 - Outputs:   RwBool - True on success.
 */
RwBool
_rxPipelineNodePS2SkinBPatchPS2ManagerInstanceCallBack(
    void **clusterData,
    RwUInt32 numClusters __RWUNUSEDRELEASE__ )
{
    /* Cluster expansion. */
    RxPS2Mesh *mesh;
    RxPS2DMASessionRecord *dmaSessionRec;
    RpAtomic *atomic;
    PatchAtomicData *atomicData;
    RpGeometry *geometry;
    RpSkin *skin;

    /* Skin extension. */
    RwUInt32 numMatrices;
    RwReal *destMBI;
    RwMatrix *mba = (RwMatrix *) NULL;
    RwUInt32 DMAstorage;
    RwUInt32 serialNum;

    RWFUNCTION(RWSTRING("_rxPipelineNodePS2SkinBPatchPS2ManagerInstanceCallBack"));
    RWASSERT(NULL != clusterData);
    RWASSERT(3 == numClusters);
    RWASSERT(NULL != clusterData[0]);
    RWASSERT(NULL != clusterData[1]);
    RWASSERT(NULL != clusterData[2]);

    /* Collect the mesh and atomic data. */
    mesh = (RxPS2Mesh *)clusterData[0];
    RWASSERT(NULL != mesh);
    dmaSessionRec = (RxPS2DMASessionRecord *)clusterData[1];
    RWASSERT(NULL != dmaSessionRec);
    destMBI = (RwReal *)(clusterData[2]);
    RWASSERT(NULL != destMBI);
    atomic = dmaSessionRec->sourceObject.atomic;
    RWASSERT(NULL != atomic);
    atomicData = PATCHATOMICGETDATA(atomic);
    RWASSERT(NULL != atomicData);
    geometry = atomic->geometry;
    RWASSERT(NULL != geometry);
    skin = _rpPatchSkyGeometryGetSkin(geometry);
    RWASSERT(NULL != skin);
    numMatrices = _rpPatchSkySkinGetNumMatrices(skin);
    DMAstorage = 0;
    serialNum = ((RwUInt32 *)(*(mesh->cacheEntryRef) + 1))[3];

    /* Skin weights and indices instancing. */
    if(dmaSessionRec->serialNum != serialNum)
    {
        _rpSkinWeightsInstancing(mesh->mesh, skin, destMBI);
    }

    if(0 == mesh->meshNum)
    {
        RwUInt32 lod;

        /* Call the lod call back. */
        RWASSERT(NULL != atomicData->lod.callback);
        lod = (atomicData->lod.callback)(atomic, atomicData->lod.userData);
        RWASSERT(rpPATCHLODMINVALUE <= lod);
        RWASSERT(rpPATCHSKINLODMAXVALUE >= lod);

        /* Construct the 128 qw lod data. */
        _rpPatchSkyMakeLOD128(_rpPatchSkyLodQW, lod);

        /* Bones matrices uploading. */
        mba = _rpSkinMatrixUpdating(atomic, skin);
        RWASSERT(NULL != mba);

        DMAstorage = numMatrices * 4;
    }

    {
        RwUInt128 ltmp = 0;
        RwUInt64 tmp, tmp1;

        /*----------- DMA data Upload -----------------------*/
        sweFinaliseOpenLocalPkt(SWE_PKT_DMA_MODE_CHAIN_TTE  |
                                SWE_PKT_LOCAL | SWE_PKT_VU1 |
                                SWE_PKT_CIRCALLOC, /**/ -(5 + DMAstorage) /**/);
        RWASSERT(NULL != sweLocalPacket);
        /*---------------------------------------------------*/

        SWE_LOCAL_BLOCK_BEGIN();

        /*------- Transfer Information ----------------------*/
        tmp  = ((1l << 28)      | (/**/ 3 + DMAstorage /**/));
        tmp1 = ((((0x6cl << 24) | ((/**/ 3 + DMAstorage /**/) << 16) |
               ((long) (pipeASymbStaticDataStart))) << 32) |
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        /*------- Patch tesselation -------------------------*/
        SWEADDCONTFAST(_rpPatchSkyLodQW);
        /*---------------------------------------------------*/

        /*------- Small Frustum Clipping information --------*/
        SWEADDCONTFAST(skyCClipVect1);
        SWEADDCONTFAST(skyCClipVect2);
        /*---------------------------------------------------*/

        /*-------- Upload Skin matrices ---------------------*/
        if(DMAstorage)
        {
            RwUInt32  i;

            for (i = 0; i < numMatrices; i++)
            {
                ltmp = *((RwUInt128 *) & mba->right.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((RwUInt128 *) & mba->up.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((RwUInt128 *) & mba->at.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((RwUInt128 *) & mba->pos.x);
                SWEADDCONTFAST(ltmp);
                mba++;
            }
        }
        /*---------------------------------------------------*/

        /*------- Terminate the DMA with an interrupt -------*/
        MAKE128(ltmp, 0l, (0xfl << 28));
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        SWE_LOCAL_BLOCK_END();

        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }

    _rpPatchSkyUpdateMetrics(_rpPatchSkyLodQW, mesh, 1);

    RWRETURN(TRUE);
}

/*****************************************************************************
 - _rpPatchSkySkinBPatchSetupTransforms
 - Initalises the _rpPatchSkySkinBPatchTransforms transforms.
 - Inputs :   none.
 - Outputs:   none.
 */
void
_rpPatchSkySkinBPatchSetupTransforms()
{
    RwUInt32 code;

    RWFUNCTION(RWSTRING("_rpPatchSkySkinBPatchSetupTransforms"));

    /* Empty the vu code array. */
    for( code = 0; code < VU1CODEARRAYSIZE; code++ )
    {
        _rpPatchSkySkinBPatchTransforms[code] = &vu1nullTrans;
    }

    _rpPatchSkySkinBPatchTransforms[TRANSNFOG | TRANSNCL  | TRANSSTRIP | TRANSPER] = &G2_SkinBPatch;
    _rpPatchSkySkinBPatchTransforms[TRANSFOG  | TRANSNCL  | TRANSSTRIP | TRANSPER] = &G2_SkinBPatch;
    _rpPatchSkySkinBPatchTransforms[TRANSNFOG | TRANSCLIP | TRANSSTRIP | TRANSPER] = &G2_SkinBPatch;
    _rpPatchSkySkinBPatchTransforms[TRANSFOG  | TRANSCLIP | TRANSSTRIP | TRANSPER] = &G2_SkinBPatch;

    RWRETURNVOID();
}

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/
