/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "rppatch.h"

#include "patchskyskin.h"

#include "G2_SkinBPatch/G2_SkinBPatchNode.h"
#include "G2_SkinBPatch/G2_SkinBPatchData.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchskyskin.c,v 1.5 2001/09/06 16:05:47 jamesa Exp $";
#endif /* (!defined(DXOYGEN)) */

/*===========================================================================*
 *--- Local Defines ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local functions -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/

/****************************************************************************
 _rpPatchSkinPipelineCreate

 Creates the skin patch pipeline.

 Inputs :   uv2  - RwBool dual set of uvs.
 Outputs:   RxPipeline * - Pointer to the created pipeline.
 */
RxPipeline *
_rpPatchSkinPipelineCreate(RwBool dualUVs)
{
    RxPipeline *pipe;
    RxLockedPipe *lpipe;
    RxNodeDefinition *manager;
    RxPipelineNode *plnode;
    RxPipelineNode *result;
    RxClusterDefinition *UVClusterDef;
    RwUInt32 UVType;

    RWFUNCTION(RWSTRING("_rpPatchSkinPipelineCreate"));

    UVClusterDef = (dualUVs) ? &RxClPS2uv2:&RxClPS2uv;
    UVType = (dualUVs) ? CL_UV2:CL_UV;

    pipe = RxPipelineCreate();
    RWASSERT(NULL != pipe);

    pipe->pluginId = rwID_PATCHPLUGIN;

    lpipe = RxPipelineLock(pipe);
    RWASSERT(NULL != lpipe);

    manager = RxNodeDefinitionGetPS2Manager(rxOBJTYPE_ATOMIC);
    RWASSERT(NULL != manager);

    lpipe = RxLockedPipeAddFragment( lpipe,
                                     (RwUInt32 *)NULL,
                                     manager,
                                     (RxNodeDefinition *)NULL );
    RWASSERT(NULL != lpipe);

    plnode = RxPipelineFindNodeByName( lpipe, manager->name,
                                       (RxPipelineNode *)NULL,
                                       (RwInt32 *)NULL );
    RWASSERT(NULL != plnode);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          &RxClPS2xyz,
                                                          CL_XYZ );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          UVClusterDef,
                                                          UVType );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          &RxClPS2rgba,
                                                          CL_RGBA );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          &RxClPS2normal,
                                                          CL_NORMAL );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2ManagerGenerateCluster( plnode,
                                                      &RxClPS2user1,
                                                      CL_USER1 );
    RWASSERT(NULL != result);

    plnode = RxPipelineNodePS2ManagerSetPointListVUBufferSize( plnode,
                 pipeASymbStrideOfInputCluster,
                 pipeASymbTSVertexCount);
    RWASSERT(NULL != plnode);

    lpipe = RxLockedPipeUnlock(lpipe);
    RWASSERT(NULL != lpipe);

    plnode = RxPipelineFindNodeByName( lpipe, manager->name,
                                       (RxPipelineNode *)NULL,
                                       (RwInt32 *)NULL);
    RWASSERT(NULL != plnode);

    plnode = RxPipelineNodePS2ManagerSetVIFOffset(plnode, pipeASymbVIFOffset);
    RWASSERT(NULL != plnode);

    /*---- New VU Array description allowing BF Culling ----*/
    ((RxPipelineNodePS2ObjAllInOneData *)plnode->privateData)->genericVU1Index =
        TRUE;

    result = RxPipelineNodePS2ManagerSetVU1CodeArray( plnode,
                 _rpPatchSkySkinBPatchTransforms );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2ManagerSetInstanceCallBack( plnode,
                 _rxPipelineNodePS2SkinBPatchPS2ManagerInstanceCallBack );
    RWASSERT(NULL != result);

    /*----
    result = RxPipelineNodePS2ManagerSetPostObjectCallBack(plnode,
                 _rpMatFXMaterialsPostObjectCallBack);
    RWASSERT(NULL != result);
      ----*/

    /*----
    result = RxPipelineNodePS2ManagerNoTexture(plnode, TRUE);
    RWASSERT(NULL != result);
      ----*/

    RWRETURN(pipe);
}

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/
