/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "rppatch.h"

#include "patchskyskinmatfx.h"
#include "patchskymatfx.h"

/* Only need one for the vu memory offsets. */
#include "G2_SkinBemBPatch/G2_SkinBemBPatchData.h"
/*#include "G2_SkinDupBPatch/G2_SkinDupBPatchData.h"*/
/*#include "G2_SkinEmbBPatch/G2_SkinEmbBPatchData.h"*/
/*#include "G2_SkinGemBPatch/G2_SkinGemBPatchData.h"*/

#include "G2_SkinBPatch/G2_SkinBPatchNode.h"
#include "G2_SkinBemBPatch/G2_SkinBemBPatchNode.h"
#include "G2_SkinDupBPatch/G2_SkinDupBPatchNode.h"
#include "G2_SkinEmbBPatch/G2_SkinEmbBPatchNode.h"
#include "G2_SkinGemBPatch/G2_SkinGemBPatchNode.h"

#include "../../plugin/matfx/effectPipes.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/
typedef struct PatchSkinMatFXData
{
    /* MatFX pipes. */
    matFXElementState uv;
    matFXElementState uv2;
} RWALIGN(PatchSkinMatFXData, rpMATFXALIGNMENT);

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchskyskinmatfx.c,v 1.9 2001/10/03 16:49:33 Blakem Exp $";
#endif /* (!defined(DXOYGEN)) */

/* Instance call back data. */
static PatchSkinMatFXData SkinMatFXData =
{
    { /*--- Skin single UV. ------------------------------------------------*/
        rpMATFXEFFECTNULL, /*--- Element state type. -----------------------*/
        { /*--- Effect instance call backs. --------------------------------*/
            _rxPipelineNodePS2SkinBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinEmbBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinGemBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinBemBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinDupBPatchPS2ManagerInstanceCallBack
        },
        { /*--- VUcode arrays. ---------------------------------------------*/
            &_rpPatchSkySkinBPatchTransforms,                      /* Null  */
            &_rpPatchSkySkinEmbBPatchTransforms,                   /* Bump  */
            &_rpPatchSkySkinGemBPatchTransforms,                   /* Env   */
            &_rpPatchSkySkinBemBPatchTransforms,                   /* BpEnv */
            &_rpPatchSkySkinDupBPatchTransforms                    /* Dual  */
        }
    },
    { /*--- SkinDual UV. ---------------------------------------------------*/
        rpMATFXEFFECTNULL, /*--- Element state type. -----------------------*/
        { /*--- Effect instance call backs. --------------------------------*/
            _rxPipelineNodePS2SkinBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinEmbBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinGemBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinBemBPatchPS2ManagerInstanceCallBack,
            _rxPipelineNodePS2SkinDupBPatchPS2ManagerInstanceCallBack
        },
        { /*--- VUcode arrays. ---------------------------------------------*/
            &_rpPatchSkySkinBPatchTransforms,                      /* Null  */
            &_rpPatchSkySkinEmbBPatchTransforms,                   /* Bump  */
            &_rpPatchSkySkinGemBPatchTransforms,                   /* Env   */
            &_rpPatchSkySkinBemBPatchTransforms,                   /* BpEnv */
            &_rpPatchSkySkinDupBPatchTransforms                    /* Dual  */
        }
    }
};

/*===========================================================================*
 *--- Local Defines ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local functions -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/

/*****************************************************************************
 _rpPatchSkinMatFXUVPipelineInstanceCallBack

 TODO

 Inputs :
 Outputs :
 */
RwBool
_rpPatchSkinMatFXUVPipelineInstanceCallBack( void **clusterData,
                                             RwUInt32 numClusters )
{
    RwBool ret;

    RWFUNCTION(RWSTRING("_rpPatchSkinMatFXUVPipelineInstanceCallBack"));
    RWASSERT(NULL != clusterData);
    RWASSERT(3 == numClusters);

    ret = _rpMatFXMaterialsInstanceCallBack( clusterData,
                                             numClusters,
                                             &(SkinMatFXData.uv) );

    RWRETURN(ret);
}

/*****************************************************************************
 _rpPatchSkinMatFXUV2PipelineInstanceCallBack

 TODO

 Inputs :
 Outputs :
 */
RwBool
_rpPatchSkinMatFXUV2PipelineInstanceCallBack( void **clusterData,
                                              RwUInt32 numClusters )
{
    RwBool ret;

    RWFUNCTION(RWSTRING("_rpPatchSkinMatFXUV2PipelineInstanceCallBack"));
    RWASSERT(NULL != clusterData);
    RWASSERT(3 == numClusters);

    ret = _rpMatFXMaterialsInstanceCallBack( clusterData,
                                             numClusters,
                                             &(SkinMatFXData.uv2) );

    RWRETURN(ret);
}

/****************************************************************************
 _rpPatchSkinMatFXPipelineCreate

 Creates the skin matfx patch pipeline.

 Inputs :   uv2  - RwBool dual set of uvs.
 Outputs:   RxPipeline * - Pointer to the created pipeline.
 */
RxPipeline *
_rpPatchSkinMatFXPipelineCreate(RwBool dualUVs)
{
    RxPipeline *pipe;
    RxLockedPipe *lpipe;
    RxNodeDefinition *manager;
    RxPipelineNode *plnode;
    RxPipelineNode *result;
    RxClusterDefinition *UVClusterDef;
    RwUInt32 UVType;
    RxPipelineNodePS2ManagerInstanceCallBack UVCallBack;

    RWFUNCTION(RWSTRING("_rpPatchSkinMatFXPipelineCreate"));

    if(dualUVs)
    {
        UVClusterDef = &RxClPS2uv2;
        UVType = CL_UV2;
        UVCallBack = _rpPatchSkinMatFXUV2PipelineInstanceCallBack;
    }
    else
    {
        UVClusterDef = &RxClPS2uv;
        UVType = CL_UV;
        UVCallBack = _rpPatchSkinMatFXUVPipelineInstanceCallBack;
    }

    pipe = RxPipelineCreate();
    RWASSERT(NULL != pipe);

    pipe->pluginId = rwID_PATCHPLUGIN;

    lpipe = RxPipelineLock(pipe);
    RWASSERT(NULL != lpipe);

    manager = RxNodeDefinitionGetPS2Manager(rxOBJTYPE_ATOMIC);
    RWASSERT(NULL != manager);

    lpipe = RxLockedPipeAddFragment( lpipe,
                                     (RwUInt32 *)NULL,
                                     manager,
                                     (RxNodeDefinition *)NULL );
    RWASSERT(NULL != lpipe);

    plnode = RxPipelineFindNodeByName( lpipe, manager->name,
                                       (RxPipelineNode *)NULL,
                                       (RwInt32 *)NULL );
    RWASSERT(NULL != plnode);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          &RxClPS2xyz,
                                                          CL_XYZ );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          UVClusterDef,
                                                          UVType );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          &RxClPS2rgba,
                                                          CL_RGBA );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2MatInstanceGenerateCluster( plnode,
                                                          &RxClPS2normal,
                                                          CL_NORMAL );
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2ManagerGenerateCluster( plnode,
                                                      &RxClPS2user1,
                                                      CL_USER1 );
    RWASSERT(NULL != result);

    plnode = RxPipelineNodePS2ManagerSetPointListVUBufferSize( plnode,
                 pipeASymbStrideOfInputCluster,
                 pipeASymbTSVertexCount);
    RWASSERT(NULL != plnode);

    lpipe = RxLockedPipeUnlock(lpipe);
    RWASSERT(NULL != lpipe);

    plnode = RxPipelineFindNodeByName( lpipe, manager->name,
                                       (RxPipelineNode *)NULL,
                                       (RwInt32 *)NULL);
    RWASSERT(NULL != plnode);

    plnode = RxPipelineNodePS2ManagerSetVIFOffset(plnode, pipeASymbVIFOffset);
    RWASSERT(NULL != plnode);

    /*---- New VU Array description allowing BF Culling ----*/
    ((RxPipelineNodePS2ObjAllInOneData *)plnode->privateData)->genericVU1Index
        = TRUE;

    /*----
    result = RxPipelineNodePS2ManagerSetVU1CodeArray( plnode,
                 MatFXData[effect].vucode );
    RWASSERT(NULL != result);
      ----*/

    result = RxPipelineNodePS2ManagerSetInstanceCallBack(plnode, UVCallBack);
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2ManagerSetPostObjectCallBack(plnode,
                 _rpMatFXMaterialsPostObjectCallBack);
    RWASSERT(NULL != result);

    result = RxPipelineNodePS2ManagerNoTexture(plnode, TRUE);
    RWASSERT(NULL != result);

    RWRETURN(pipe);
}

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/
