#ifndef _SKIND3D8_H
#define _SKIND3D8_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpskin.h"

/*===========================================================================*
 *--- Global Types ----------------------------------------------------------*
 *===========================================================================*/
struct SkinPlatformData
{
    RwUInt32 empty;
};

struct SkinGlobalPlatform
{
    RwUInt32 empty;
};

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/
#define rpSKINMAXNUMBEROFMATRICES 256

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/
typedef struct __rxD3D8SkinInstanceNodeData _rxD3D8SkinInstanceNodeData;
struct __rxD3D8SkinInstanceNodeData
{
    RxD3D8AllInOneRenderCallBack    renderCallback;     /* Render callback */
};

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RwBool
_rwD3D8SkinAtomicAllInOnePipelineInit(RxPipelineNode *node);

extern void
_rwD3D8MeshGetNumVerticesMinIndex(RxVertexIndex *indices,
                        RwUInt32 numIndices,
                        RwInt32 *numVertices,
                        RwUInt32 *min);

extern void _rwD3D8ResourceEntryInstanceDataDestroy(RwResEntry *repEntry);

extern void _rwD3D8AtomicDefaultLightingCallback(void *object);

extern RwBool _rxD3D8VertexBufferManagerCreate(RwUInt32 fvf,
                                               RwUInt32 size,
                                               void **vertexBuffer,
                                               RwUInt32 *baseIndex);
extern void _rxD3D8VertexBufferManagerDestroy(RwUInt32 fvf,
                                              RwUInt32 size,
                                              void *vertexBuffer,
                                              RwUInt32 baseIndex);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _SKIND3D8_H */
