#include <d3d8.h>

#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"

#include "skin.h"

#include "skind3d8plain.h"

#if (!defined(DOXYGEN))
static const char rcsid[] __RWUNUSED__ = 
    "@@@@(#)$Id: skind3d8plain.c,v 1.2 2001/09/27 11:06:33 markf Exp $";
#endif /* (!defined(DOXYGEN)) */

/****************************************************************************
 _rwD3D8SkinAtomicAllInOnePipelineInit
 */
RwBool
_rwD3D8SkinAtomicAllInOnePipelineInit(RxPipelineNode *node)
{
    _rxD3D8SkinInstanceNodeData *instanceData;

    RxNodeDefinition    *instanceDefaultNode;
    RxPipelineNode      *defaultNode;

    RWFUNCTION(RWSTRING("_rwD3D8SkinAtomicAllInOnePipelineInit"));

    instanceData = (_rxD3D8SkinInstanceNodeData *)node->privateData;

    /*
     * Find default render callback
     */
    /* Get the instance node definition */
    instanceDefaultNode = RxNodeDefinitionGetD3D8AtomicAllInOne();
    RWASSERT(NULL != instanceDefaultNode);

    defaultNode = RxPipelineFindNodeByName(RpAtomicGetDefaultInstancePipeline(), instanceDefaultNode->name, NULL, NULL);

    if (defaultNode != NULL)
    {
        instanceData->renderCallback = RxD3D8AllInOneGetRenderCallBack(defaultNode);
    }
    else
    {
        instanceData->renderCallback = NULL;
    }

    RWRETURN(TRUE);
}
