/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include "rwcore.h"
#include "rpworld.h"

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "rpskin.h"

#include "skin.h"
#include "skinskygeneric.h"

#include "SKY2_SkinGeneric/SKY2_SkinGenericNode.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: ";
#endif /* (!defined(DXOYGEN)) */

/*===========================================================================*
 *--- Local Defines ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local functions -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/

/****************************************************************************
 _rpSkinPipelinesCreate

 Create the skin pipelines.

 Inputs :   pipes - RwUInt32 bit-field defining which pipes to create
                        rpSKINPIPELINESKINGENERIC = 0x01,
                        rpSKINPIPELINESKINMATFX   = 0x02,
 Outputs:   RwBool - on success.
 */
RwBool
_rpSkinPipelinesCreate( RwUInt32 pipes )
{
    RWFUNCTION(RWSTRING("_rpSkinPipelinesCreate"));

    /* Should we create the generic pipeline. */
    if(pipes & rpSKINPIPELINESKINGENERIC)
    {
        /* Setup the vu transforms. */
        _rpSkinSkySkinGenericSetupTransforms();

        /* Create the pipeline. */

        /* PS2Manager generic skin pipeline. */
        _rpSkinPS2ManagerPipeline(rpSKINSKYPIPELINEGENERIC) =
            _rpSkinPS2ManagerGenericPipeCreate();
        RWASSERT(NULL != _rpSkinPS2ManagerPipeline(rpSKINSKYPIPELINEGENERIC));

        /* PS2All material generic skin pipeline. */
        _rpSkinPS2AllMaterialPipeline(rpSKINSKYPIPELINEGENERIC) =
            _rpSkinPS2AllMaterialGenericPipeCreate();
        RWASSERT( NULL !=
                  _rpSkinPS2AllMaterialPipeline(rpSKINSKYPIPELINEGENERIC) );

        /* PS2All generic skin pipeline. */
        _rpSkinPS2AllPipeline(rpSKINSKYPIPELINEGENERIC) =
            _rpSkinPS2AllGenericPipeCreate(
                _rpSkinPS2AllMaterialPipeline(rpSKINSKYPIPELINEGENERIC) );
        RWASSERT(NULL != _rpSkinPS2AllPipeline(rpSKINSKYPIPELINEGENERIC));
    }

    RWRETURN(TRUE);
}

/****************************************************************************
 _rpSkinPipelinesDestroy

 Destroy the skin pipelines.

 Inputs :   None
 Outputs:   RwBool - on success.
 */
RwBool
_rpSkinPipelinesDestroy(void)
{
    SkinSkyPipeline iPipeline;

    RWFUNCTION(RWSTRING("_rpSkinPipelinesDestroy"));

    for( iPipeline = rpSKINSKYPIPELINEGENERIC;
         iPipeline < rpSKINSKYPIPELINEMAX; 
         iPipeline = (SkinSkyPipeline)(1 + (RwUInt32)iPipeline))
    {
        /* PS2Manager generic skin pipeline. */
        if(NULL != _rpSkinPS2ManagerPipeline(iPipeline))
        {
            RxPipelineDestroy(_rpSkinPS2ManagerPipeline(iPipeline));
            _rpSkinPS2ManagerPipeline(iPipeline) = (RxPipeline *)NULL;
        }
        RWASSERT(NULL == _rpSkinPS2ManagerPipeline(iPipeline));

        /* PS2All material generic skin pipeline. */
        if(NULL != _rpSkinPS2AllMaterialPipeline(iPipeline))
        {
            RxPipelineDestroy(_rpSkinPS2AllMaterialPipeline(iPipeline));
            _rpSkinPS2AllMaterialPipeline(iPipeline) = (RxPipeline *)NULL;
        }
        RWASSERT(NULL == _rpSkinPS2AllMaterialPipeline(iPipeline));

        /* PS2All generic skin pipeline. */
        if(NULL != _rpSkinPS2AllPipeline(iPipeline))
        {
            RxPipelineDestroy(_rpSkinPS2AllPipeline(iPipeline));
            _rpSkinPS2AllPipeline(iPipeline) = (RxPipeline *)NULL;
        }
        RWASSERT(NULL == _rpSkinPS2AllPipeline(iPipeline));
    }

    RWRETURN(TRUE);
}

/****************************************************************************
 _rpSkinPipelinesAttach

 Attach the generic skinning pipeline to an atomic.

 Inputs :   atomic *   - Pointer to the atomic.
 Outputs:   RpAtomic * - Pointer to the atomic on success.
 */
RpAtomic *
_rpSkinPipelinesAttach(RpAtomic * atomic)
{
    SkinSkyPipeline iPipeline;
    RxPipeline *pipeline;

    RWFUNCTION(RWSTRING("_rpSkinPipelinesAttach"));

    iPipeline = rpSKINSKYPIPELINEGENERIC;

    pipeline = _rpSkinPS2ManagerPipeline(iPipeline);
    RWASSERT(NULL != pipeline);

    atomic = RpAtomicSetPipeline(atomic, pipeline);
    RWASSERT(NULL != atomic);

    RWRETURN(atomic);
}

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/
