#ifndef _SKINNULL_H
#define _SKINNULL_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpskin.h"

/*===========================================================================*
 *--- Global Types ----------------------------------------------------------*
 *===========================================================================*/
struct SkinGlobalPlatform
{
    RwUInt32 empty;
};

struct SkinPlatformData
{
    RwInt32 *matrixIndexMap;
    RwInt32 *vertexIndexMap;
    RwInt32 numBonesUsed;
    RwInt32 maxWeightsUsed;
};

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/
#define rpSKINMAXNUMBEROFMATRICES 256

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/

extern RwBool
_rpSkinXboxPipelinesCreateExtra( RwUInt32 pipes );

extern void
_rpSkinXboxPipelinesDestroyExtra( void );

extern RwInt32
_rpSkinXboxGetMaterialMatfxHash( RpMaterial *material, RwUInt32 geoFlags );

extern RwInt32
_rpSkinXboxMaterialSetUp( RpMaterial *mat, RwInt32 pass );

extern void
_rpSkinXboxMaterialTearDown( RpMaterial *material );

extern void
_rpSkinSetEnvMatrix( RwFrame *frame );

extern void
_rpSkinSetBumpConstants(RwV4d *bumpPosFudge, RwV4d *bumpShift);

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _SKINNULL_H */
