
/***************************************************************************
 *                                                                         *
 * Module  : pipes.h                                                       *
 *                                                                         *
 * Purpose :                                                               *
 *                                                                         *
 **************************************************************************/

#ifndef PIPES_H
#define PIPES_H

/****************************************************************************
 Includes

*/
#include <rwcore.h>

/****************************************************************************
 Defines
 */

extern long null2d __attribute__ ((section(".vudata")));

#define NULL2D (&null2d)

/****************************************************************************
 Global Types
 */

/*=== Array of 16 flavors of VU tarnsform/rendering code; bits correspond to ===*/
typedef void       *VUCodeArray[16];

/*=== State shared by functions in this file ===*/
typedef struct Rt2dPS2PipeState Rt2dPS2PipeState;
struct Rt2dPS2PipeState
{
    RwUInt64            subdiv;
    RxPipeline         *Pipeline;
    void               *vucode[VU1CODEARRAYSIZE];
};

 /****************************************************************************
 Function prototypes
 */

/* init */
extern RwBool       _rt2dPS2PipeOpen(void);

extern void         _rt2dPS2PipeClose(void);

extern RwBool       __rt2dPS2FontOpen(void);

extern RwBool       __rt2dPS2FontClose(void);

#endif /* PIPES_H */
