/***************************************************************************
 *                                                                         *
 * Module  : bapipif.h                                                     *
 *                                                                         *
 * Purpose : Pipeline interface for world module                           *
 *                                                                         *
 **************************************************************************/

#ifndef RWPIPIF_H
#define RWPIPIF_H

/****************************************************************************
 Includes
 */

#include <rwcore.h>
#include "balight.h"

/****************************************************************************
 Defines
 */

typedef RwBool (*rwWorldPipeAttachFn)(void);
typedef RwBool (*rwPipeSetupAtomPipeFn)(RwRenderPipeline *pipe);
typedef RwBool (*rwPipeSetupSectPipeFn)(RwRenderPipeline *pipe);
typedef void (*rwPipeSetupLightApply)(RpLight *light);

typedef struct _rpWorldPipeInterface rpWorldPipeInterface;
struct _rpWorldPipeInterface
{
    rwWorldPipeAttachFn         pipeAttach;
    rwPipeSetupAtomPipeFn       pipeSetupAtomPipe;
    rwPipeSetupSectPipeFn       pipeSetupSectPipe;
    rwPipeSetupLightApply       pipeSetupLightApply;
};

/****************************************************************************
 Global Types
 */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern const rpWorldPipeInterface *rpGetWorldPipeInterface(void);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* RWPIPIF_H */
