// StreamReaderAscii.h: interface for the StreamReaderAscii class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STREAMREADERASCII_H__54C95F14_61FE_4EB6_8B77_FDD3BB5E298E__INCLUDED_)
#define AFX_STREAMREADERASCII_H__54C95F14_61FE_4EB6_8B77_FDD3BB5E298E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StreamReader.h"

class StreamReaderAscii : public StreamReader  
{
	enum { MAXTOKENSIZE = 256};
public:
	StreamReaderAscii();
	~StreamReaderAscii();

	virtual bool	getChar(char & Char);
	virtual bool	getInt(int & Int);
	virtual bool	getu32(u32 & ref);
	virtual bool	getFloat(float & Float);
	virtual bool	getString(char *& String);
	virtual bool	getIdentifier(char *& Id);
	virtual bool	getBeginSection();
	bool    getToEndOfLine(char *& Line);


	void 	setVersionNumber(float version);
	virtual bool	dumpSection();  //dumps everything to the end of current section including '}'
	
protected:

	virtual	bool	getEndSection();
	bool	tokenIsBeginSection();
	bool	dumpVersion(float version);
	bool	tokenIsVersion();	//current token is VERSION Id
	bool	tokenIsEndVersion();  //current token is ENDVERSION
	bool	validateVersion(float versionNumber);  //checks version to see if it is <= the set version

	
	bool	isWhiteSpace( char curChar);
	bool	getToken();

	//holds token after parsed
	char	m_tokenBuffer[MAXTOKENSIZE];

	//pointer to current whitespace string
	char *	m_whiteSpace;
	
	// all code marked at a higher version will be discarded
	float	m_versionNumber;

	//flag set after token is read to determine if the token was a string in the file
	bool	m_tokenIsString;

	//flag set after version dump started so that nested VERSION tokens are ignored
	// turned off when corresponding ENDVERSION found
	bool	m_versionCheckOn;
		
	//whitespace definitions for different sections
	static char * cWhiteSpace;		//look for normal white space
	static char * cStringWhiteSpace; // look for end quote
	static char * cCommentWhiteSpace;  // look for new line

};

#endif // !defined(AFX_STREAMREADERASCII_H__54C95F14_61FE_4EB6_8B77_FDD3BB5E298E__INCLUDED_)
